<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
// Database configuration - SAME AS ADMIN
$db_host = 'localhost';
$db_user = 'rsisinternation1_new_journal_flo';
$db_pass = 'weDCVrG3$%fv78T';
$db_name = 'rsisinternation1_new_journal_flow';
try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}
// Check if user is logged in and is an author
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'author') {
    header("Location: ../admin/login.php");
    exit();
}
$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['username'] ?? 'Author';
// Fetch user details
try {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
 
    if (!$user) {
        session_destroy();
        header("Location: ../admin/login.php");
        exit();
    }
} catch (PDOException $e) {
    die("Error fetching user: " . $e->getMessage());
}
// Handle password change
$password_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_password'])) {
    $current_password = $_POST['current_password'] ?? '';
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
 
    if (password_verify($current_password, $user['password'])) {
        if ($new_password === $confirm_password && strlen($new_password) >= 6) {
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $update_stmt = $pdo->prepare("UPDATE users SET password = ?, updated_at = NOW() WHERE id = ?");
            $update_stmt->execute([$hashed_password, $user_id]);
            $password_message = '<div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">Password changed successfully!</div>';
        } else {
            $password_message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">New passwords do not match or are too short (min 6 characters).</div>';
        }
    } else {
        $password_message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">Current password is incorrect.</div>';
    }
}
// Fetch author's submissions
try {
    // $submissions_stmt = $pdo->prepare("
    //     SELECT s.*, j.name as journal_name, j.slug as journal_slug
    //     FROM submissions s
    //     LEFT JOIN journals j ON s.journal_id = j.id
    //     WHERE s.author_id = ?
    //     ORDER BY s.submitted_at DESC
    // ");
    $submissions_stmt = $pdo->prepare("
    SELECT s.*, j.name as journal_name, j.slug as journal_slug,
           (SELECT ed.due_date FROM editorial_decisions ed 
            WHERE ed.submission_id = s.id 
            ORDER BY ed.created_at DESC 
            LIMIT 1) as latest_due_date
    FROM submissions s
    LEFT JOIN journals j ON s.journal_id = j.id
    WHERE s.author_id = ?
    ORDER BY s.submitted_at DESC
    ");
    $submissions_stmt->execute([$user_id]);
    $submissions = $submissions_stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $submissions = [];
}
// Fetch author's tickets
try {
    $tickets_stmt = $pdo->prepare("
        SELECT t.*, s.title as submission_title, s.tracking_code as submission_tracking_code
        FROM author_tickets t
        LEFT JOIN submissions s ON t.submission_id = s.id
        WHERE t.author_id = ?
        ORDER BY t.created_at DESC
    ");
    $tickets_stmt->execute([$user_id]);
    $tickets = $tickets_stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $tickets = [];
}
// Fetch all active journals
try {
    $journals_stmt = $pdo->query("SELECT id, name, slug FROM journals WHERE is_active = 1 ORDER BY name");
    $journals = $journals_stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $journals = [];
}
$active_section = $_GET['section'] ?? 'submissions';
// Journal Metadata Configuration
$journal_metadata = [
    1 => [ // IJRISS - assuming journal_id = 1
        'name' => 'International Journal of Research and Innovation in Social Science (IJRISS)',
        'slug' => 'IJRISS',
        'issn' => '2454-6186',
        'doi' => '10.47772/IJRISS',
        'signature' => "Thanks,<br>Editorial Office<br>International Journal of Research and Innovation in Social Science (IJRISS)<br>ISSN: 2454-6186<br>DOI Number: 10.47772/IJRISS",
        'revised_link' => 'https://rsisinternational.org/journals/ijriss/revised-manuscript-submission/',
        'final_link' => 'https://rsisinternational.org/journals/ijriss/final-manuscript-submission/',
        'declaration_link' => 'https://rsisinternational.org/journals/ijriss/wp-content/uploads/2018/08/Author-s-Declaration.pdf'
    ],
    2 => [ // IJRIAS - assuming journal_id = 2
        'name' => 'International Journal of Research and Innovation in Applied Science (IJRIAS)',
        'slug' => 'IJRIAS',
        'issn' => '2454-6194',
        'doi' => '10.51584/IJRIAS',
        'signature' => "Thanks,<br>Editorial Office<br>International Journal of Research and Innovation in Applied Science (IJRIAS)<br>ISSN: 2454-6194<br>DOI Number: 10.51584/IJRIAS",
        'revised_link' => 'https://rsisinternational.org/journals/ijrias/revised-manuscript-submission/',
        'final_link' => 'https://rsisinternational.org/journals/ijrias/final-manuscript-submission/',
        'declaration_link' => 'https://rsisinternational.org/journals/ijrias/images/Author%20(s)%20Declaration.pdf'
    ],
    3 => [ // IJRSI - assuming journal_id = 3
        'name' => 'International Journal of Research and Scientific Innovation (IJRSI)',
        'slug' => 'IJRSI',
        'issn' => '2321-2705',
        'doi' => '10.51244/IJRSI',
        'signature' => "Thanks,<br>Editorial Office<br>International Journal of Research and Scientific Innovation (IJRSI)<br>ISSN: 2321-2705<br>DOI Number: 10.51244/IJRSI",
        'revised_link' => 'https://rsisinternational.org/journals/ijrsi/revised-manuscript-submission/',
        'final_link' => 'https://rsisinternational.org/journals/ijrsi/final-manuscript-submission/',
        'declaration_link' => 'https://rsisinternational.org/journals/ijrsi/wp-content/uploads/2018/01/Author-s-Declaration.pdf'
    ],
    4 => [ // IJLTEMAS - assuming journal_id = 4
        'name' => 'International Journal of Latest Technology in Engineering, Management & Applied Science (IJLTEMAS)',
        'slug' => 'IJLTEMAS',
        'issn' => '2278-2540',
        'doi' => '10.51583/IJLTEMAS',
        'signature' => "Thanks,<br>Editorial Office<br>International Journal of Latest Technology in Engineering, Management & Applied Science (IJLTEMAS)<br>ISSN: 2278-2540<br>DOI Number: 10.51583/IJLTEMAS",
        'revised_link' => 'https://www.ijltemas.in/revised-manuscript-submission/',
        'final_link' => 'https://www.ijltemas.in/final-manuscript-submission/',
        'declaration_link' => 'https://www.ijltemas.in/images/Author(s)Declaration.pdf'
    ]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Author Dashboard - RSIS International</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            margin: 0;
            height: 100vh;
            overflow: hidden;
        }
        .sidebar {
            width: 250px;
            background: #2d3748;
            color: white;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 10;
            overflow-y: auto;
        }
        .sidebar.collapsed {
            width: 70px;
        }
        .sidebar.collapsed .sidebar-title,
        .sidebar.collapsed nav ul li a span {
            display: none;
        }
        .content {
            margin-left: 250px;
            height: 100vh;
            overflow-y: auto;
            transition: margin-left 0.3s;
        }
        .content.expanded {
            margin-left: 70px;
        }
        .nav-item {
            padding: 12px 20px;
            cursor: pointer;
            transition: background 0.3s;
            display: flex;
            align-items: center;
            gap: 12px;
            text-decoration: none;
            color: white;
        }
        .nav-item:hover {
            background: #4a5568;
        }
        .nav-item.active {
            background: #4a5568;
            border-left: 4px solid #3b82f6;
        }
        .status-badge {
            padding: 4px 12px;
            border-radius: 9999px;
            font-size: 12px;
            font-weight: 600;
        }
        /* Ticket status badges */
.ticket-status-open { background: #dbeafe; color: #1e40af; }
.ticket-status-in_progress { background: #fef3c7; color: #92400e; }
.ticket-status-resolved { background: #d1fae5; color: #065f46; }
.ticket-status-closed { background: #f3f4f6; color: #374151; }
        .status-pending { background: #fef3c7; color: #92400e; }
        .status-under_review { background: #dbeafe; color: #1e40af; }
        .status-approved { background: #d1fae5; color: #065f46; }
        .status-rejected { background: #fee2e2; color: #991b1b; }
        .status-published { background: #d1fae5; color: #065f46; }
        .status-draft { background: #f3f4f6; color: #374151; }
     
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-250px);
            }
            .sidebar.mobile-open {
                transform: translateX(0);
            }
            .content {
                margin-left: 0;
            }
        }
        /* Print Styles */
@media print {
    /* Hide everything by default when printing */
    body * {
        visibility: hidden;
    }
 
    /* Hide sidebar and header completely */
    .sidebar,
    header,
    .no-print {
        display: none !important;
    }
 
    /* Show only the main content area */
    .content {
        margin-left: 0 !important;
        width: 100% !important;
    }
 
    /* Show only the editor review content */
    #content main,
    #content main * {
        visibility: visible;
    }
 
    /* Position the printable content at the top */
    #content main {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
    }
 
    /* Show print-only header */
    .print-only {
        display: block !important;
    }
 
    /* Ensure proper page breaks */
    .page-break-inside-avoid {
        page-break-inside: avoid;
        break-inside: avoid;
    }
 
    /* Remove shadows and adjust colors for print */
    .bg-white,
    .rounded-lg,
    .shadow-md {
        box-shadow: none !important;
    }
 
    /* Ensure text is black for better print quality */
    body {
        color: #000 !important;
        background: #fff !important;
    }
 
    /* Adjust spacing for print */
    .p-6 {
        padding: 1rem !important;
    }
 
    /* Make borders print-friendly */
    .border {
        border: 1px solid #000 !important;
    }
}
/*=================submission modal============================*/
/* Modal Styles */
.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0,0,0,0.5);
    animation: fadeIn 0.3s;
}
@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}
.modal-content {
    background-color: #fefefe;
    margin: 5% auto;
    padding: 0;
    border-radius: 8px;
    width: 90%;
    max-width: 600px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    animation: slideIn 0.3s;
}
@keyframes slideIn {
    from {
        transform: translateY(-50px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}
.modal-header {
    padding: 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 8px 8px 0 0;
}
.modal-body {
    padding: 20px;
    max-height: 60vh;
    overflow-y: auto;
}
.modal-footer {
    padding: 15px 20px;
    background-color: #f8f9fa;
    border-radius: 0 0 8px 8px;
    display: flex;
    justify-content: flex-end;
    gap: 10px;
}
.close {
    color: white;
    float: right;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
    line-height: 20px;
}
.close:hover,
.close:focus {
    opacity: 0.7;
}
.file-upload-box {
    border: 2px dashed #cbd5e0;
    border-radius: 8px;
    padding: 20px;
    text-align: center;
    transition: all 0.3s;
    background-color: #f7fafc;
}
.file-upload-box:hover {
    border-color: #4299e1;
    background-color: #ebf8ff;
}
.file-upload-box.uploaded {
    border-color: #48bb78;
    background-color: #f0fff4;
}
.file-upload-box.disabled {
    opacity: 0.5;
    cursor: not-allowed;
    background-color: #e2e8f0;
}
.uploaded-file-info {
    background-color: #d4edda;
    border: 1px solid #c3e6cb;
    border-radius: 4px;
    padding: 10px;
    margin-top: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}
    </style>
 
</head>
<body class="bg-gray-100">
    <!-- Mobile Menu Button -->
    <button id="mobileMenuBtn" class="fixed top-4 left-4 z-20 md:hidden bg-gray-800 text-white px-3 py-2 rounded-md">
        <i class="fas fa-bars"></i>
    </button>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="flex items-center justify-between p-4 bg-gray-900">
            <div class="sidebar-title">
                <h2 class="text-xl font-bold text-white">RSIS</h2>
                <p class="text-sm text-gray-300">Author Portal</p>
            </div>
            <button class="text-white focus:outline-none" id="toggleSidebar">
                <i class="fas fa-bars"></i>
            </button>
        </div>
        <nav class="mt-4">
            <ul class="space-y-1">
                <li>
                    <a href="?section=submissions" class="nav-item <?php echo $active_section === 'submissions' ? 'active' : ''; ?>">
                        <i class="fas fa-file-alt text-lg"></i>
                        <span>My Submissions</span>
                    </a>
                </li>
                <li>
                    <a href="?section=new_submission" class="nav-item <?php echo $active_section === 'new_submission' ? 'active' : ''; ?>">
                        <i class="fas fa-plus-circle text-lg"></i>
                        <span>New Submission</span>
                    </a>
                </li>
                <li>
                    <a href="?section=tickets" class="nav-item <?php echo $active_section === 'tickets' ? 'active' : ''; ?>">
                        <i class="fas fa-ticket-alt text-lg"></i>
                        <span>My Tickets</span>
                    </a>
                </li>
                <li>
                    <a href="?section=raise_ticket" class="nav-item <?php echo $active_section === 'raise_ticket' ? 'active' : ''; ?>">
                        <i class="fas fa-question-circle text-lg"></i>
                        <span>Raise a Ticket</span>
                    </a>
                </li>
                <li>
                    <a href="?section=profile" class="nav-item <?php echo $active_section === 'profile' ? 'active' : ''; ?>">
                        <i class="fas fa-user text-lg"></i>
                        <span>My Profile</span>
                    </a>
                </li>
                <li>
                    <a href="?section=change_password" class="nav-item <?php echo $active_section === 'change_password' ? 'active' : ''; ?>">
                        <i class="fas fa-key text-lg"></i>
                        <span>Change Password</span>
                    </a>
                </li>
                <li>
                    <a href="logout.php" class="nav-item">
                        <i class="fas fa-sign-out-alt text-lg"></i>
                        <span>Logout</span>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
    <!-- Main Content -->
    <div class="content" id="content">
        <!-- Header -->
        <header class="bg-white shadow-md p-4 sticky top-0 z-10">
            <div class="flex justify-between items-center">
                <h1 class="text-2xl font-bold text-gray-800">Author Dashboard</h1>
                <div class="flex items-center space-x-4">
                    <span class="text-gray-700">Welcome, <strong><?php echo htmlspecialchars($user_name); ?></strong></span>
                    <a href="logout.php" class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                        <i class="fas fa-sign-out-alt mr-2"></i>Logout
                    </a>
                </div>
            </div>
        </header>
        <!-- Main Content Area -->
        <main class="p-6">
         
         
                        <?php if ($active_section === 'raise_ticket'): ?>
                <!-- Raise a Ticket Form -->
                <div class="bg-white rounded-lg shadow-md p-6 max-w-3xl mx-auto">
                    <h2 class="text-2xl font-semibold mb-6 text-gray-800">
                        <i class="fas fa-question-circle text-blue-600 mr-2"></i>Raise a Ticket
                    </h2>
                 
                    <div id="ticket-message"></div>
                 
                    <form id="raiseTicketForm">
                        <!-- Select Submission -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Related Submission <span class="text-gray-500">(Optional)</span>
                            </label>
                            <select name="submission_id" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                <option value="">-- Select Submission (if query is related to a submission) --</option>
                                <?php foreach ($submissions as $submission): ?>
                                    <option value="<?php echo $submission['id']; ?>">
                                        <?php echo htmlspecialchars($submission['tracking_code']); ?> - <?php echo htmlspecialchars(substr($submission['title'], 0, 60)); ?><?php echo strlen($submission['title']) > 60 ? '...' : ''; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <p class="text-sm text-gray-500 mt-1">Select a submission if your query is related to a specific manuscript</p>
                        </div>
                        <!-- Query Subject -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Query Subject <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="subject" required maxlength="255" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Brief description of your query">
                        </div>
                        <!-- Query Message -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Query Message <span class="text-red-500">*</span>
                            </label>
                            <textarea name="message" rows="8" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Please provide detailed information about your query..."></textarea>
                            <p class="text-sm text-gray-500 mt-1">Provide as much detail as possible to help us resolve your query quickly</p>
                        </div>
                        <!-- Priority (Optional) -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Priority
                            </label>
                            <select name="priority" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                <option value="low">Low - General inquiry</option>
                                <option value="medium" selected>Medium - Standard query</option>
                                <option value="high">High - Urgent matter</option>
                                <option value="urgent">Urgent - Critical issue</option>
                            </select>
                        </div>
                        <!-- Submit Button -->
                        <div class="flex gap-4">
                            <button type="submit" class="bg-blue-600 text-white px-8 py-3 rounded-lg hover:bg-blue-700 font-semibold">
                                <i class="fas fa-paper-plane mr-2"></i>Submit Ticket
                            </button>
                            <a href="?section=tickets" class="bg-gray-500 text-white px-8 py-3 rounded-lg hover:bg-gray-600 font-semibold inline-block">
                                <i class="fas fa-list mr-2"></i>View My Tickets
                            </a>
                        </div>
                    </form>
                </div>
            <?php elseif ($active_section === 'tickets'): ?>
                <!-- My Tickets -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-semibold text-gray-800">
                            <i class="fas fa-ticket-alt text-blue-600 mr-2"></i>My Tickets
                        </h2>
                        <a href="?section=raise_ticket" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                            <i class="fas fa-plus mr-2"></i>Raise New Ticket
                        </a>
                    </div>
                 
                    <?php if (empty($tickets)): ?>
                        <div class="text-center py-12">
                            <i class="fas fa-inbox text-6xl text-gray-300 mb-4"></i>
                            <p class="text-gray-500 text-lg mb-4">No tickets yet</p>
                            <a href="?section=raise_ticket" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 inline-block">
                                <i class="fas fa-plus mr-2"></i>Raise Your First Ticket
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="space-y-4">
                            <?php foreach ($tickets as $ticket): ?>
                                <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow">
                                    <div class="flex justify-between items-start mb-3">
                                        <div class="flex-1">
                                            <h3 class="text-lg font-semibold text-gray-800 mb-1">
                                                <?php echo htmlspecialchars($ticket['subject']); ?>
                                            </h3>
                                            <p class="text-sm text-gray-600 mb-2">
                                                Ticket #<?php echo htmlspecialchars($ticket['ticket_number']); ?>
                                                <?php if ($ticket['submission_title']): ?>
                                                    <span class="mx-2">•</span>
                                                    Related to: <span class="font-mono text-xs"><?php echo htmlspecialchars($ticket['submission_tracking_code']); ?></span>
                                                <?php endif; ?>
                                            </p>
                                        </div>
                                        <span class="status-badge ticket-status-<?php echo strtolower($ticket['status']); ?>">
                                            <?php echo ucfirst(str_replace('_', ' ', $ticket['status'])); ?>
                                        </span>
                                    </div>
                                 
                                    <p class="text-gray-700 mb-3 line-clamp-2">
                                        <?php echo htmlspecialchars(substr($ticket['message'], 0, 200)); ?>
                                        <?php echo strlen($ticket['message']) > 200 ? '...' : ''; ?>
                                    </p>
                                 
                                    <div class="flex justify-between items-center">
                                        <span class="text-sm text-gray-500">
                                            <i class="fas fa-clock mr-1"></i>
                                            Created: <?php echo date('M d, Y g:i A', strtotime($ticket['created_at'])); ?>
                                        </span>
                                        <a href="?section=view_ticket&id=<?php echo $ticket['id']; ?>" class="text-blue-600 hover:text-blue-800 font-semibold">
                                            <i class="fas fa-eye mr-1"></i>View Details
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php elseif ($active_section === 'view_ticket'): ?>
                <!-- View Ticket Details -->
                <?php
                $ticket_id = $_GET['id'] ?? 0;
                $ticket_stmt = $pdo->prepare("
                    SELECT t.*, s.title as submission_title, s.tracking_code as submission_tracking_code,
                           u.username as responder_name
                    FROM author_tickets t
                    LEFT JOIN submissions s ON t.submission_id = s.id
                    LEFT JOIN users u ON t.responded_by = u.id
                    WHERE t.id = ? AND t.author_id = ?
                ");
                $ticket_stmt->execute([$ticket_id, $user_id]);
                $ticket = $ticket_stmt->fetch(PDO::FETCH_ASSOC);
             
                if (!$ticket):
                ?>
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                        Ticket not found or you don't have permission to view it.
                    </div>
                <?php else:
                    // Fetch ticket replies
                    $replies_stmt = $pdo->prepare("
                        SELECT r.*, u.username, u.role
                        FROM ticket_replies r
                        LEFT JOIN users u ON r.user_id = u.id
                        WHERE r.ticket_id = ?
                        ORDER BY r.created_at ASC
                    ");
                    $replies_stmt->execute([$ticket_id]);
                    $replies = $replies_stmt->fetchAll(PDO::FETCH_ASSOC);
                ?>
                    <div class="bg-white rounded-lg shadow-md p-6">
                        <div class="flex justify-between items-start mb-6">
                            <h2 class="text-2xl font-semibold text-gray-800">Ticket Details</h2>
                            <a href="?section=tickets" class="text-blue-600 hover:text-blue-800">
                                <i class="fas fa-arrow-left mr-2"></i>Back to Tickets
                            </a>
                        </div>
                     
                        <div class="bg-gray-50 p-4 rounded-lg mb-6">
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-600 mb-1">Ticket Number</label>
                                    <p class="text-lg font-mono text-gray-800"><?php echo htmlspecialchars($ticket['ticket_number']); ?></p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-600 mb-1">Status</label>
                                    <span class="status-badge ticket-status-<?php echo strtolower($ticket['status']); ?>">
                                        <?php echo ucfirst(str_replace('_', ' ', $ticket['status'])); ?>
                                    </span>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-600 mb-1">Priority</label>
                                    <span class="px-3 py-1 rounded-full text-sm font-semibold
                                        <?php
                                            echo $ticket['priority'] === 'urgent' ? 'bg-red-100 text-red-800' :
                                                ($ticket['priority'] === 'high' ? 'bg-orange-100 text-orange-800' :
                                                ($ticket['priority'] === 'medium' ? 'bg-yellow-100 text-yellow-800' :
                                                'bg-gray-100 text-gray-800'));
                                        ?>">
                                        <?php echo ucfirst($ticket['priority']); ?>
                                    </span>
                                </div>
                            </div>
                         
                            <?php if ($ticket['submission_title']): ?>
                                <div class="border-t pt-4">
                                    <label class="block text-sm font-medium text-gray-600 mb-1">Related Submission</label>
                                    <p class="text-gray-800">
                                        <span class="font-mono text-sm"><?php echo htmlspecialchars($ticket['submission_tracking_code']); ?></span>
                                        - <?php echo htmlspecialchars($ticket['submission_title']); ?>
                                    </p>
                                </div>
                            <?php endif; ?>
                        </div>
                     
                        <div class="mb-6">
                            <h3 class="text-lg font-semibold text-gray-800 mb-2">Subject</h3>
                            <p class="text-gray-800"><?php echo htmlspecialchars($ticket['subject']); ?></p>
                        </div>
                     
                        <div class="mb-6">
                            <h3 class="text-lg font-semibold text-gray-800 mb-2">Query Message</h3>
                            <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded">
                                <p class="text-gray-700 whitespace-pre-wrap"><?php echo htmlspecialchars($ticket['message']); ?></p>
                                <p class="text-sm text-gray-500 mt-3">
                                    <i class="fas fa-clock mr-1"></i>
                                    <?php echo date('F d, Y g:i A', strtotime($ticket['created_at'])); ?>
                                </p>
                            </div>
                        </div>
                     
                        <?php if ($ticket['admin_response']): ?>
                            <div class="mb-6">
                                <h3 class="text-lg font-semibold text-gray-800 mb-2">Admin Response</h3>
                                <div class="bg-green-50 border-l-4 border-green-500 p-4 rounded">
                                    <p class="text-gray-700 whitespace-pre-wrap"><?php echo htmlspecialchars($ticket['admin_response']); ?></p>
                                    <p class="text-sm text-gray-500 mt-3">
                                        <i class="fas fa-user mr-1"></i>
                                        Responded by: <?php echo htmlspecialchars($ticket['responder_name'] ?? 'Admin'); ?>
                                        <span class="mx-2">•</span>
                                        <i class="fas fa-clock mr-1"></i>
                                        <?php echo date('F d, Y g:i A', strtotime($ticket['responded_at'])); ?>
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?>
                     
                        <?php if (!empty($replies)): ?>
                            <div class="mb-6">
                                <h3 class="text-lg font-semibold text-gray-800 mb-4">Conversation Thread</h3>
                                <div class="space-y-4">
                                    <?php foreach ($replies as $reply): ?>
                                        <div class="<?php echo $reply['is_admin'] ? 'bg-green-50 border-l-4 border-green-500' : 'bg-blue-50 border-l-4 border-blue-500'; ?> p-4 rounded">
                                            <div class="flex justify-between items-start mb-2">
                                                <span class="font-semibold text-gray-800">
                                                    <?php echo $reply['is_admin'] ? '<i class="fas fa-user-shield mr-1"></i>' : '<i class="fas fa-user mr-1"></i>'; ?>
                                                    <?php echo htmlspecialchars($reply['username']); ?>
                                                    <?php echo $reply['is_admin'] ? '<span class="text-xs bg-green-600 text-white px-2 py-1 rounded ml-2">Admin</span>' : ''; ?>
                                                </span>
                                                <span class="text-sm text-gray-500">
                                                    <?php echo date('M d, Y g:i A', strtotime($reply['created_at'])); ?>
                                                </span>
                                            </div>
                                            <p class="text-gray-700 whitespace-pre-wrap"><?php echo htmlspecialchars($reply['message']); ?></p>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                     
                        <?php if ($ticket['status'] !== 'closed'): ?>
                            <div class="border-t pt-6">
                                <h3 class="text-lg font-semibold text-gray-800 mb-4">Add Reply</h3>
                                <div id="reply-message"></div>
                                <form id="replyTicketForm" data-ticket-id="<?php echo $ticket['id']; ?>">
                                    <textarea name="reply_message" rows="4" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent mb-3" placeholder="Type your reply here..."></textarea>
                                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 font-semibold">
                                        <i class="fas fa-reply mr-2"></i>Send Reply
                                    </button>
                                </form>
                            </div>
                        <?php else: ?>
                            <div class="bg-gray-100 border border-gray-300 text-gray-700 px-4 py-3 rounded">
                                <i class="fas fa-lock mr-2"></i>This ticket is closed and no longer accepting replies.
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
         
         
            <?php elseif ($active_section === 'submissions'): ?>
                <!-- My Submissions -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-2xl font-semibold mb-6 text-gray-800">My Submissions</h2>
                 
                    <?php if (empty($submissions)): ?>
                        <div class="text-center py-12">
                            <i class="fas fa-inbox text-6xl text-gray-300 mb-4"></i>
                            <p class="text-gray-500 text-lg mb-4">No submissions yet</p>
                            <a href="?section=new_submission" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 inline-block">
                                <i class="fas fa-plus mr-2"></i>Submit Your First Manuscript
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="overflow-x-auto">
                            <table class="w-full text-sm text-left">
                                <thead class="bg-gray-50 border-b">
                                    <tr>
                                        <th class="px-4 py-3 font-semibold text-gray-700">Tracking Code</th>
                                        <th class="px-4 py-3 font-semibold text-gray-700">Title</th>
                                        <th class="px-4 py-3 font-semibold text-gray-700">Journal</th>
                                        <th class="px-4 py-3 font-semibold text-gray-700">Status</th>
                                        <th class="px-4 py-3 font-semibold text-gray-700">Due Date</th>
                                        <th class="px-4 py-3 font-semibold text-gray-700">Submitted</th>
                                        <th class="px-4 py-3 font-semibold text-gray-700">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($submissions as $submission): ?>
                                 
                                        <?php
                                            // Get journal metadata for this submission
                                            $journal_data = $journal_metadata[$submission['journal_id']] ?? null;
                                         
                                            // Check if editorial decision exists
                                            $check_decision = $pdo->prepare("SELECT COUNT(*) FROM editorial_decisions WHERE submission_id = ?");
                                            $check_decision->execute([$submission['id']]);
                                            $has_decision = $check_decision->fetchColumn() > 0;
                                         
                                            // Check if status is accepted or accepted_with_changes
                                            $is_accepted = in_array($submission['status'], ['accepted', 'accepted_with_changes']);
                                        ?>
                         
                                        <tr class="border-b hover:bg-gray-50">
                                            <td class="px-4 py-3 font-mono text-sm"><?php echo htmlspecialchars($submission['tracking_code'] ?? 'N/A'); ?></td>
                                            <td class="px-4 py-3 max-w-xs truncate" title="<?php echo htmlspecialchars($submission['title']); ?>"><?php echo htmlspecialchars($submission['title']); ?></td>
                                            <td class="px-4 py-3"><?php echo htmlspecialchars($submission['journal_name'] ?? 'N/A'); ?></td>
                                            <td class="px-4 py-3">
                                                <span class="status-badge status-<?php echo strtolower($submission['status']); ?>">
                                                    <?php echo ucfirst(str_replace('_', ' ', $submission['status'])); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <?php if (!empty($submission['latest_due_date'])): ?>
                                                    <span class="text-sm text-dark-500 block mt-1">
                                                        <i class="fas fa-calendar-alt mr-1"></i>
                                                        Due: <?php echo date('M d, Y', strtotime($submission['latest_due_date'])); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="px-4 py-3"><?php echo date('M d, Y', strtotime($submission['submitted_at'])); ?></td>
                                         
                                         
                                            <!-- In the submissions table, replace the Actions column content with this: -->
<td class="px-4 py-3">
    <div class="flex flex-col gap-2">
        <a href="?section=view_submission&id=<?php echo $submission['id']; ?>"
           class="text-blue-600 hover:text-blue-800 text-sm">
            <i class="fas fa-eye"></i> View
        </a>
     
        <?php if ($submission['file_url']): ?>
            <a href="../../common/author/<?php echo htmlspecialchars($submission['file_url']); ?>"
               target="_blank"
               class="text-green-600 hover:text-green-800 text-sm">
                <i class="fas fa-download"></i> Download
            </a>
        <?php endif; ?>
     
        <!-- View Editor Review Button -->
        <?php
        $check_decision = $pdo->prepare("SELECT COUNT(*) FROM editorial_decisions WHERE submission_id = ?");
        $check_decision->execute([$submission['id']]);
        $has_decision = $check_decision->fetchColumn() > 0;
     
        if ($has_decision):
            // Check for final submission status
            $final_sub_stmt = $pdo->prepare("SELECT * FROM final_submissions WHERE submission_id = ? AND author_id = ?");
            $final_sub_stmt->execute([$submission['id'], $user_id]);
            $final_submission = $final_sub_stmt->fetch(PDO::FETCH_ASSOC);
        ?>
            <a href="?section=view_editor_review&submission_id=<?php echo $submission['id']; ?>"
               class="text-purple-600 hover:text-purple-800 text-sm">
                <i class="fas fa-file-signature"></i> View Review
            </a>
         
            <?php if ($is_accepted): ?>
            <a href="https://rsisinternational.org/journals/common/payment/paypalpay.php?tracking_code=<?php echo $submission['tracking_code']; ?>"
               class="text-blue-600 hover:text-blue-800 text-sm"
               target="_blank">
                <i class="fa-brands fa-paypal"></i> Make Payment
            </a>
         
            <!-- Download Author Declaration -->
            <?php if ($journal_data && !empty($journal_data['declaration_link'])): ?>
                <a href="<?php echo htmlspecialchars($journal_data['declaration_link']); ?>"
                   class="text-indigo-600 hover:text-indigo-800 text-sm"
                   target="_blank"
                   title="Download Author Declaration for <?php echo htmlspecialchars($journal_data['slug']); ?>">
                    <i class="fas fa-file-pdf"></i> Download Declaration
                </a>
            <?php endif; ?>
         
            <!-- Final Submission Button -->
            <button onclick="openFinalSubmissionModal(<?php echo $submission['id']; ?>, '<?php echo htmlspecialchars($submission['tracking_code']); ?>', <?php echo $final_submission ? 'true' : 'false'; ?>)"
                    class="text-white <?php echo ($final_submission && $final_submission['is_complete']) ? 'bg-gray-500 cursor-not-allowed' : 'bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700'; ?> px-3 py-1 rounded text-sm font-semibold"
                    <?php echo ($final_submission && $final_submission['is_complete']) ? 'disabled' : ''; ?>>
                <i class="fas fa-upload"></i>
                <?php echo $final_submission ? ($final_submission['is_complete'] ? 'Submitted ✓' : 'Continue Submission') : 'Final Submission'; ?>
            </button>
         
            <!-- Show uploaded files if any exist (KEEP THIS INSIDE THE IF - submission-specific) -->
            <?php if ($final_submission): ?>
                <div class="text-xs text-gray-600 mt-1 pl-2">
                    <?php if ($final_submission['payment_receipt']): ?>
                        <a href="../../common/author/<?php echo htmlspecialchars($final_submission['payment_receipt']); ?>"
                           target="_blank"
                           class="text-green-600 hover:underline block">
                            <i class="fas fa-check-circle"></i> Payment Receipt
                        </a>
                    <?php endif; ?>
                    <?php if ($final_submission['declaration_form']): ?>
                        <a href="../../common/author/<?php echo htmlspecialchars($final_submission['declaration_form']); ?>"
                           target="_blank"
                           class="text-green-600 hover:underline block">
                            <i class="fas fa-check-circle"></i> Declaration Form
                        </a>
                    <?php endif; ?>
                    <?php if ($final_submission['final_manuscript']): ?>
                        <a href="../../common/author/<?php echo htmlspecialchars($final_submission['final_manuscript']); ?>"
                           target="_blank"
                           class="text-green-600 hover:underline block">
                            <i class="fas fa-check-circle"></i> Final Manuscript
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php endif; ?>
         
            <?php endif; // END if ($has_decision) ?>
        <!-- Resubmit Button for 'resubmit' status -->
        <?php if ($submission['status'] === 'resubmit'): ?>
            <a href="#" onclick="openResubmitModal(<?php echo $submission['id']; ?>)" class="text-orange-600 hover:text-orange-800 text-sm">
                <i class="fas fa-redo"></i> Resubmit Manuscript
            </a>
        <?php endif; ?>
        
        <!-- Show resubmission file if it exists -->
            <?php if (!empty($submission['resubmission_file'])): ?>
                <div class="text-xs text-gray-600 mt-1 pl-2">
                    <a href="../../common/author/uploads/resubmission/<?php echo htmlspecialchars($submission['resubmission_file']); ?>"
                       target="_blank"
                       class="text-orange-600 hover:underline block">
                        <i class="fas fa-check-circle"></i> Resubmission File
                    </a>
                </div>
            <?php endif; ?>
        
        </div>
    </td>
                                         
                                         
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
<!--==============================================================================-->
<?php elseif ($active_section === 'view_editor_review'): ?>
    <!-- View Editor Review -->
    <?php
    $submission_id = $_GET['submission_id'] ?? 0;
 
    // Fetch submission details
    $submission_stmt = $pdo->prepare("
        SELECT s.*, j.name as journal_name
        FROM submissions s
        LEFT JOIN journals j ON s.journal_id = j.id
        WHERE s.id = ? AND s.author_id = ?
    ");
    $submission_stmt->execute([$submission_id, $user_id]);
    $submission = $submission_stmt->fetch(PDO::FETCH_ASSOC);
 
    if (!$submission):
    ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
            Submission not found or you don't have permission to view it.
        </div>
    <?php else:
        // Fetch editorial decisions for this submission
        $decisions_stmt = $pdo->prepare("
            SELECT
                ed.*,
                u.username as editor_username,
                u.first_name as editor_first_name,
                u.last_name as editor_last_name,
                u.email as editor_email,
                r.id as review_id,
                ru.first_name as reviewer_first_name,
                ru.last_name as reviewer_last_name
            FROM editorial_decisions ed
            JOIN users u ON ed.editor_id = u.id
            LEFT JOIN reviews r ON ed.based_on_review_id = r.id
            LEFT JOIN reviewers rv ON r.reviewer_id = rv.id
            LEFT JOIN users ru ON rv.user_id = ru.id
            WHERE ed.submission_id = ?
            ORDER BY ed.created_at DESC
        ");
        $decisions_stmt->execute([$submission_id]);
        $editorial_decisions = $decisions_stmt->fetchAll(PDO::FETCH_ASSOC);
     
        if (empty($editorial_decisions)):
    ?>
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex justify-between items-start mb-6">
                    <h2 class="text-2xl font-semibold text-gray-800">Editor's Review</h2>
                    <a href="?section=submissions" class="text-blue-600 hover:text-blue-800">
                        <i class="fas fa-arrow-left mr-2"></i>Back to Submissions
                    </a>
                </div>
                <div class="text-center py-12">
                    <i class="fas fa-inbox text-6xl text-gray-300 mb-4"></i>
                    <p class="text-gray-500 text-lg">No editorial review available yet</p>
                    <p class="text-gray-400 text-sm mt-2">The editor's review will appear here once it's completed</p>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-white rounded-lg shadow-md p-6">
                <!-- HEADER WITH PRINT BUTTON -->
                <div class="flex justify-between items-start mb-6 no-print">
                    <div>
                        <h2 class="text-2xl font-semibold text-gray-800">Editor's Review & Decision</h2>
                        <p class="text-gray-600 mt-1">Submission: <?php echo htmlspecialchars($submission['tracking_code']); ?></p>
                    </div>
                    <div class="flex gap-3">
                        <!-- PRINT BUTTON -->
                        <button onclick="window.print()" class="bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700 font-semibold flex items-center gap-2">
                            <i class="fas fa-print"></i>
                            Print / Save as PDF
                        </button>
                        <a href="?section=submissions" class="text-blue-600 hover:text-blue-800">
                            <i class="fas fa-arrow-left mr-2"></i>Back to Submissions
                        </a>
                    </div>
                </div>
                <!-- Print-only header (shows only when printing) -->
                <div class="print-only mb-6" style="display: none;">
                    <div class="text-center border-b-2 border-gray-300 pb-4 mb-4">
                        <h1 class="text-3xl font-bold text-gray-900">Editorial Review Report</h1>
                        <p class="text-gray-600 mt-2">Submission: <?php echo htmlspecialchars($submission['tracking_code']); ?></p>
                        <p class="text-sm text-gray-500">Generated on: <?php echo date('F d, Y g:i A'); ?></p>
                    </div>
                </div>
             
                <!-- Submission Title -->
                <div class="bg-gray-50 p-4 rounded-lg mb-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-2"><?php echo htmlspecialchars($submission['title']); ?></h3>
                    <p class="text-sm text-gray-600">
                        <span class="font-medium">Journal:</span> <?php echo htmlspecialchars($submission['journal_name'] ?? 'N/A'); ?>
                        <span class="mx-3">•</span>
                        <span class="font-medium">Submitted:</span> <?php echo date('M d, Y', strtotime($submission['submitted_at'])); ?>
                    </p>
                </div>
             
                <!-- Editorial Decisions -->
                <?php foreach ($editorial_decisions as $index => $decision): ?>
                <div class="border border-gray-200 rounded-lg mb-6 overflow-hidden page-break-inside-avoid">
                    <!-- Decision Header -->
                    <div class="bg-gradient-to-r from-indigo-50 to-purple-50 px-6 py-4 border-b">
                        <div class="flex justify-between items-start">
                            <div>
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-block px-4 py-2 rounded-full text-sm font-bold
                                        <?php
                                            $decisionColors = [
                                                'accepted' => 'bg-green-100 text-green-800 border-2 border-green-500',
                                                'accepted_with_changes' => 'bg-blue-100 text-blue-800 border-2 border-blue-500',
                                                'resubmit' => 'bg-orange-100 text-orange-800 border-2 border-orange-500',
                                                'rejected' => 'bg-red-100 text-red-800 border-2 border-red-500'
                                            ];
                                            echo $decisionColors[$decision['decision']] ?? 'bg-gray-100 text-gray-800';
                                        ?>">
                                        <?php
                                            $decisionTitles = [
                                                'accepted' => '✓ ACCEPTED',
                                                'accepted_with_changes' => '✓ ACCEPTED WITH CHANGES',
                                                'resubmit' => '↻ RESUBMIT FOR REVIEW',
                                                'rejected' => '✗ REJECTED'
                                            ];
                                            echo $decisionTitles[$decision['decision']] ?? strtoupper($decision['decision']);
                                        ?>
                                    </span>
                                 
                                    <?php if ($index === 0): ?>
                                    <span class="px-3 py-1 bg-yellow-400 text-yellow-900 text-xs font-bold rounded-full">
                                        LATEST
                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                         
                            <div class="text-right">
                                <p class="text-sm text-gray-600">
                                    <i class="fas fa-calendar-alt"></i>
                                    <?php echo date('F d, Y', strtotime($decision['created_at'])); ?>
                                </p>
                                <p class="text-xs text-gray-500">
                                    <?php echo date('g:i A', strtotime($decision['created_at'])); ?>
                                </p>
                                <p class="text-sm text-gray-500">
                                    Due Date : <?php echo date('F d, Y', strtotime($decision['due_date'])); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                 
                    <!-- Decision Content -->
                    <div class="px-6 py-4">
                        <!-- Evaluation Scores -->
                        <?php if (!empty($decision['originality']) || !empty($decision['presentation']) || !empty($decision['applicability']) || !empty($decision['overall_status'])): ?>
                        <div class="mb-6">
                            <h4 class="font-semibold text-gray-700 mb-3 flex items-center gap-2">
                                <i class="fas fa-star text-yellow-500"></i>
                                Evaluation Scores
                            </h4>
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                                <?php if (!empty($decision['originality'])): ?>
                                <div class="bg-blue-50 border border-blue-200 p-4 rounded-lg text-center">
                                    <p class="text-xs text-gray-600 mb-1">Originality</p>
                                    <p class="text-lg font-bold text-blue-700"><?php echo htmlspecialchars($decision['originality']); ?></p>
                                </div>
                                <?php endif; ?>
                             
                                <?php if (!empty($decision['presentation'])): ?>
                                <div class="bg-green-50 border border-green-200 p-4 rounded-lg text-center">
                                    <p class="text-xs text-gray-600 mb-1">Presentation</p>
                                    <p class="text-lg font-bold text-green-700"><?php echo htmlspecialchars($decision['presentation']); ?></p>
                                </div>
                                <?php endif; ?>
                             
                                <?php if (!empty($decision['applicability'])): ?>
                                <div class="bg-purple-50 border border-purple-200 p-4 rounded-lg text-center">
                                    <p class="text-xs text-gray-600 mb-1">Applicability</p>
                                    <p class="text-lg font-bold text-purple-700"><?php echo htmlspecialchars($decision['applicability']); ?></p>
                                </div>
                                <?php endif; ?>
                             
                                <?php if (!empty($decision['overall_status'])): ?>
                                <div class="bg-orange-50 border border-orange-200 p-4 rounded-lg text-center">
                                    <p class="text-xs text-gray-600 mb-1">Overall Status</p>
                                    <p class="text-lg font-bold text-orange-700"><?php echo htmlspecialchars($decision['overall_status']); ?></p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                     
                        <!-- Recommendation Summary -->
                        <?php if (!empty($decision['recommendation'])): ?>
                        <div class="mb-6 bg-blue-50 border-l-4 border-blue-500 p-4 rounded">
                            <h4 class="font-semibold text-gray-700 mb-2 flex items-center gap-2">
                                <i class="fas fa-thumbs-up text-blue-600"></i>
                                Recommendation Summary
                            </h4>
                            <p class="text-gray-800 whitespace-pre-wrap leading-relaxed">
                                <?php echo nl2br(htmlspecialchars($decision['recommendation'])); ?>
                            </p>
                        </div>
                        <?php endif; ?>
                     
                        <!-- Detailed Feedback -->
                        <div class="space-y-4">
                            <!-- Strengths -->
                            <?php if (!empty($decision['strengths'])): ?>
                            <div class="page-break-inside-avoid">
                                <h4 class="font-semibold text-gray-700 mb-2 flex items-center gap-2">
                                    <i class="fas fa-check-circle text-green-600"></i>
                                    Strengths
                                </h4>
                                <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                                    <p class="text-gray-800 whitespace-pre-wrap leading-relaxed">
                                        <?php echo nl2br(htmlspecialchars($decision['strengths'])); ?>
                                    </p>
                                </div>
                            </div>
                            <?php endif; ?>
                         
                            <!-- Weaknesses -->
                            <?php if (!empty($decision['weaknesses'])): ?>
                            <div class="page-break-inside-avoid">
                                <h4 class="font-semibold text-gray-700 mb-2 flex items-center gap-2">
                                    <i class="fas fa-exclamation-triangle text-red-600"></i>
                                    Areas for Improvement
                                </h4>
                                <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                                    <p class="text-gray-800 whitespace-pre-wrap leading-relaxed">
                                        <?php echo nl2br(htmlspecialchars($decision['weaknesses'])); ?>
                                    </p>
                                </div>
                            </div>
                            <?php endif; ?>
                         
                            <!-- Suggestions -->
                            <?php if (!empty($decision['suggestions'])): ?>
                            <div class="page-break-inside-avoid">
                                <h4 class="font-semibold text-gray-700 mb-2 flex items-center gap-2">
                                    <i class="fas fa-lightbulb text-yellow-600"></i>
                                    Suggestions for Improvement
                                </h4>
                                <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                                    <p class="text-gray-800 whitespace-pre-wrap leading-relaxed">
                                        <?php echo nl2br(htmlspecialchars($decision['suggestions'])); ?>
                                    </p>
                                </div>
                            </div>
                            <?php endif; ?>
                         
                            <!-- Editor Comments -->
                            <?php if (!empty($decision['editor_comments'])): ?>
                            <div class="page-break-inside-avoid">
                                <h4 class="font-semibold text-gray-700 mb-2 flex items-center gap-2">
                                    <i class="fas fa-comment text-purple-600"></i>
                                    Additional Comments from Editor
                                </h4>
                                <div class="bg-purple-50 border border-purple-200 rounded-lg p-4">
                                    <p class="text-gray-800 whitespace-pre-wrap leading-relaxed">
                                        <?php echo nl2br(htmlspecialchars($decision['editor_comments'])); ?>
                                    </p>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            
<?php if (!empty($decision['review_file'])): ?>
<div class="page-break-inside-avoid">
    <h4 class="font-semibold text-gray-700 mb-2 flex items-center gap-2">
        <i class="fas fa-comment text-purple-600"></i>
        Review File
    </h4>
    <div class="bg-purple-50 border border-purple-200 rounded-lg p-4">
        <?php
        // Assuming review_file stores the filename only (e.g., 'review.18.17635835.docx')
        // Adjust the base path based on script location: from /journals/common/author/ to /journals/common/admin/uploads/reviews/
        $base_upload_dir = '../admin/uploads/reviews/';
        $full_file_path = $base_upload_dir . basename($decision['review_file']);
        $web_accessible_path = '/journals/common/admin/uploads/reviews/' . basename($decision['review_file']); // For web URL
        ?>
        <?php if (file_exists($full_file_path)): ?>
            <button onclick="window.open('<?php echo htmlspecialchars($web_accessible_path); ?>', '_blank')" 
                    class="inline-flex items-center px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition-colors mb-3 focus:outline-none focus:ring-2 focus:ring-purple-500">
                <i class="fas fa-external-link-alt mr-2"></i>
                Open Review File
            </button>
            <p class="text-sm text-gray-600">Click the button above to view the full review file in a new tab.</p>
        <?php else: ?>
            <p class="text-red-600 text-sm">Review file not found or inaccessible at: <?php echo htmlspecialchars($full_file_path); ?></p>
            <?php
            // Debug: Log or echo the expected path for troubleshooting
            error_log("Review file check - Expected path: " . $full_file_path . " - Exists: " . (file_exists($full_file_path) ? 'Yes' : 'No'));
            ?>
        <?php endif; ?>
        <!-- Optional: Show a preview snippet if review_file also contains inline text (fallback if no file) -->
        <?php if (strlen($decision['review_file']) < 500 && !file_exists($full_file_path)): // Show snippet only if short and no file ?>
            <p class="text-gray-800 whitespace-pre-wrap leading-relaxed mt-2 pt-2 border-t border-purple-200">
                <?php echo nl2br(htmlspecialchars($decision['review_file'])); ?>
            </p>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>
                            
                        </div>
                     
                        <!-- Next Steps -->
                        <div class="mt-6 pt-4 border-t page-break-inside-avoid">
                            <h4 class="font-semibold text-gray-700 mb-3 flex items-center gap-2">
                                <i class="fas fa-tasks text-indigo-600"></i>
                                Next Steps
                            </h4>
                            <div class="bg-indigo-50 border border-indigo-200 rounded-lg p-4">
                                <?php if ($decision['decision'] === 'accepted'): ?>
                                    <p class="text-gray-800">
                                        <i class="fas fa-check-circle text-green-600 mr-2"></i>
                                        Congratulations! Your manuscript has been accepted for publication. Now You can submit Author Declaration and Final paper and make the payment.
                                    </p>
                                <?php elseif ($decision['decision'] === 'accepted_with_changes'): ?>
                                    <p class="text-gray-800">
                                        <i class="fas fa-edit text-blue-600 mr-2"></i>
                                        Your manuscript has been accepted with minor revisions. Please address the comments above and resubmit your revised manuscript.You can submit Author Declaration and Final paper and make the payment.
                                    </p>
                                <?php elseif ($decision['decision'] === 'resubmit'): ?>
                                    <p class="text-gray-800">
                                        <i class="fas fa-redo text-orange-600 mr-2"></i>
                                        Please carefully review the feedback provided and revise your manuscript accordingly. You may resubmit after addressing the concerns raised.
                                    </p>
                                <?php elseif ($decision['decision'] === 'rejected'): ?>
                                    <p class="text-gray-800">
                                        <i class="fas fa-times-circle text-red-600 mr-2"></i>
                                        Unfortunately, your manuscript has not been accepted for publication at this time. We appreciate your interest in our journal.
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
             
                <!-- Action Buttons (hide on print) -->
                <div class="flex gap-4 mt-6 no-print">
                    <a href="?section=submissions" class="bg-gray-600 text-white px-6 py-3 rounded-lg hover:bg-gray-700 font-semibold">
                        <i class="fas fa-arrow-left mr-2"></i>Back to Submissions
                    </a>
                    <a href="?section=raise_ticket&submission_id=<?php echo $submission_id; ?>" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 font-semibold">
                        <i class="fas fa-question-circle mr-2"></i>Have Questions? Raise a Ticket
                    </a>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
<!--==============================================================================-->
 
 
<!--==============================================================================-->
            <?php elseif ($active_section === 'new_submission'): ?>
                <!-- New Submission Form -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-2xl font-semibold mb-6 text-gray-800">Submit New Manuscript</h2>
                 
                    <div id="submission-message"></div>
                 
                    <form id="newSubmissionForm" enctype="multipart/form-data">
                        <!-- Journal Selection -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Select Journal <span class="text-red-500">*</span>
                            </label>
                            <select name="journal_id" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                <option value="">-- Select Journal --</option>
                                <?php foreach ($journals as $journal): ?>
                                    <option value="<?php echo $journal['id']; ?>">
                                        <?php echo htmlspecialchars($journal['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <!-- Desired Issue -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Desired Issue <span class="text-red-500">*</span>
                            </label>
                            <select name="desired_issue" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                <option value="">Select Issue</option>
                                <option value="current">Current Issue</option>
                                <option value="next">Next Issue</option>
                                <option value="special">Special Issue</option>
                            </select>
                        </div>
                        <!-- Manuscript Title -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Manuscript Title <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="title" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <!-- Abstract -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Abstract <span class="text-red-500">*</span>
                            </label>
                            <textarea name="abstract" rows="6" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"></textarea>
                        </div>
                        <!-- Keywords -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Keywords <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="keywords" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <p class="text-sm text-gray-500 mt-1">Separate keywords with commas</p>
                        </div>
                        <!-- Number of Authors -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Total Authors <span class="text-red-500">*</span>
                            </label>
                            <input type="number" name="total_authors" id="total_authors" value="1" min="1" max="20" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <!-- Author Details -->
                        <div class="mb-6">
                            <h3 class="text-lg font-semibold mb-4 text-gray-800">Author Details</h3>
                            <div id="authors-container"></div>
                        </div>
                        <!-- Corresponding Author Details (Pre-filled and Locked) -->
<div class="mb-6 bg-blue-50 p-6 rounded-lg border-2 border-blue-300">
    <h3 class="text-lg font-semibold mb-4 text-gray-800 flex items-center">
        <i class="fas fa-user-shield text-blue-600 mr-2"></i>
        Corresponding Author Details
    </h3>
    <div class="bg-blue-100 border-l-4 border-blue-500 p-3 mb-4">
        <p class="text-sm text-blue-800">
            <i class="fas fa-info-circle mr-2"></i>
            <strong>Note:</strong> You are automatically set as the corresponding author.
            All details are pre-filled from your profile and cannot be changed here.
            To update any information, please visit the "My Profile" section first, then return to submit your manuscript.
        </p>
    </div>
 
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <!-- Name - PRE-FILLED & READONLY -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                Full Name <span class="text-red-500">*</span>
                <i class="fas fa-lock text-gray-400 text-xs ml-1" title="This field is locked"></i>
            </label>
            <input
                type="text"
                name="corresponding_author_name"
                value="<?php echo htmlspecialchars(trim(($user['first_name'] ?? '') . ' ' . ($user['last_name'] ?? ''))); ?>"
                readonly
                required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-gray-100 cursor-not-allowed"
            >
            <input type="hidden" name="corresponding_author_name_hidden" value="<?php echo htmlspecialchars(trim(($user['first_name'] ?? '') . ' ' . ($user['last_name'] ?? ''))); ?>">
        </div>
     
        <!-- Email - PRE-FILLED & READONLY -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                Email <span class="text-red-500">*</span>
                <i class="fas fa-lock text-gray-400 text-xs ml-1" title="This field is locked"></i>
            </label>
            <input
                type="email"
                name="corresponding_author_email"
                value="<?php echo htmlspecialchars($user['email']); ?>"
                readonly
                required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-gray-100 cursor-not-allowed"
            >
            <input type="hidden" name="corresponding_author_email_hidden" value="<?php echo htmlspecialchars($user['email']); ?>">
        </div>
     
        <!-- Mobile Number - EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                Mobile Number <span class="text-red-500">*</span>
            </label>
            <input
                type="text"
                name="corresponding_author_mobile"
                maxlength="15"
                required
                placeholder="+1234567890"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
            <p class="text-xs text-gray-500 mt-1">Include country code (e.g., +44 7123456789)</p>
        </div>
     
        <!-- WhatsApp Number - EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                WhatsApp Number <span class="text-red-500">*</span>
            </label>
            <input
                type="text"
                name="corresponding_author_whatsapp"
                maxlength="15"
                required
                placeholder="+1234567890"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
            <p class="text-xs text-gray-500 mt-1">Include country code (e.g., +44 7123456789)</p>
        </div>
     
        <!-- Department - EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                Department <span class="text-red-500">*</span>
            </label>
            <input
                type="text"
                name="corresponding_author_department"
                required
                placeholder="e.g., Computer Science"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
        </div>
     
        <!-- Organization/University - PRE-FILLED BUT EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                Organization/University <span class="text-red-500">*</span>
            </label>
            <input
                type="text"
                name="corresponding_author_organisation"
                value="<?php echo htmlspecialchars($user['affiliation'] ?? ''); ?>"
                required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
        </div>
     
        <!-- City - EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                City <span class="text-red-500">*</span>
            </label>
            <input
                type="text"
                name="corresponding_author_city"
                required
                placeholder="e.g., London"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
        </div>
     
        <!-- State/Province - EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                State/Province <span class="text-gray-500">(Optional)</span>
            </label>
            <input
                type="text"
                name="corresponding_author_state"
                placeholder="e.g., England"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
        </div>
     
        <!-- Country - PRE-FILLED BUT EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                Country <span class="text-red-500">*</span>
            </label>
            <input
                type="text"
                name="corresponding_author_country"
                value="<?php echo htmlspecialchars($user['country'] ?? ''); ?>"
                required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
        </div>
     
        <!-- Author Type - EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                You Are? <span class="text-red-500">*</span>
            </label>
            <select
                name="author_type"
                required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
                <option value="">-- Select --</option>
                <option value="student">Student</option>
                <option value="researcher">Researcher</option>
                <option value="professor">Professor</option>
                <option value="professional">Professional</option>
                <option value="other">Other</option>
            </select>
        </div>
     
        <!-- Author Category - EDITABLE -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">
                Author Category <span class="text-red-500">*</span>
            </label>
            <select
                name="author_category"
                required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
            >
                <option value="">-- Select --</option>
                <option value="academic">Academic</option>
                <option value="industry">Industry</option>
                <option value="independent">Independent Researcher</option>
            </select>
        </div>
    </div>
 
    <div class="mt-4 p-3 bg-yellow-50 border-l-4 border-yellow-400 text-yellow-800 text-sm">
        <i class="fas fa-exclamation-triangle mr-2"></i>
        <strong>Important:</strong> Please ensure all contact information is accurate. All correspondence regarding your submission will be sent to these details.
    </div>
</div>
                        <!-- Number of Pages -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Number of Pages <span class="text-red-500">*</span>
                            </label>
                            <input type="number" name="num_pages" min="1" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <!-- File Upload -->
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Upload Manuscript <span class="text-red-500">*</span>
                            </label>
                            <input type="file" name="manuscript_file" id="manuscript_file" accept=".doc,.docx,.rtf" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <p class="text-sm text-gray-500 mt-1">Allowed formats: .doc, .docx, .rtf (Max 2MB)</p>
                        </div>
                        <!-- Agreement -->
                        <div class="mb-6">
                            <label class="flex items-start">
                                <input type="checkbox" name="agree_terms" required class="mt-1 mr-3">
                                <span class="text-sm text-gray-700">
                                    I agree to the Author's Declaration and consent to receive information regarding my submitted paper <span class="text-red-500">*</span>
                                </span>
                            </label>
                        </div>
                        <!-- Submit Buttons -->
                        <div class="flex gap-4">
                            <button type="submit" name="action" value="submit" class="bg-blue-600 text-white px-8 py-3 rounded-lg hover:bg-blue-700 font-semibold">
                                <i class="fas fa-paper-plane mr-2"></i>Submit Manuscript
                            </button>
                            <button type="button" id="saveDraftBtn" class="bg-gray-500 text-white px-8 py-3 rounded-lg hover:bg-gray-600 font-semibold">
                                <i class="fas fa-save mr-2"></i>Save as Draft
                            </button>
                        </div>
                    </form>
                </div>
            <?php elseif ($active_section === 'profile'): ?>
                <!-- Profile Section -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-2xl font-semibold mb-6 text-gray-800">My Profile</h2>
                 
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Username</label>
                            <p class="text-lg text-gray-800"><?php echo htmlspecialchars($user['username']); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Email</label>
                            <p class="text-lg text-gray-800"><?php echo htmlspecialchars($user['email']); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">First Name</label>
                            <p class="text-lg text-gray-800"><?php echo htmlspecialchars($user['first_name'] ?? 'N/A'); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Last Name</label>
                            <p class="text-lg text-gray-800"><?php echo htmlspecialchars($user['last_name'] ?? 'N/A'); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Affiliation</label>
                            <p class="text-lg text-gray-800"><?php echo htmlspecialchars($user['affiliation'] ?? 'N/A'); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Country</label>
                            <p class="text-lg text-gray-800"><?php echo htmlspecialchars($user['country'] ?? 'N/A'); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Member Since</label>
                            <p class="text-lg text-gray-800"><?php echo date('F d, Y', strtotime($user['created_at'])); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Account Status</label>
                            <p class="text-lg">
                                <span class="px-3 py-1 rounded-full text-sm font-semibold <?php echo $user['is_active'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                                    <?php echo $user['is_active'] ? 'Active' : 'Inactive'; ?>
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            <?php elseif ($active_section === 'change_password'): ?>
                <!-- Change Password -->
                <div class="bg-white rounded-lg shadow-md p-6 max-w-2xl">
                    <h2 class="text-2xl font-semibold mb-6 text-gray-800">Change Password</h2>
                 
                    <?php echo $password_message; ?>
                 
                    <form method="POST" class="space-y-6 mt-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Current Password <span class="text-red-500">*</span>
                            </label>
                            <input type="password" name="current_password" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                     
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                New Password <span class="text-red-500">*</span>
                            </label>
                            <input type="password" name="new_password" required minlength="6" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <p class="text-sm text-gray-500 mt-1">Minimum 6 characters</p>
                        </div>
                     
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Confirm New Password <span class="text-red-500">*</span>
                            </label>
                            <input type="password" name="confirm_password" required minlength="6" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                     
                        <div>
                            <button type="submit" name="change_password" class="bg-blue-600 text-white px-8 py-3 rounded-lg hover:bg-blue-700 font-semibold">
                                <i class="fas fa-key mr-2"></i>Change Password
                            </button>
                        </div>
                    </form>
                </div>
            <?php elseif ($active_section === 'view_submission'): ?>
                <!-- View Submission Details -->
                <?php
                $submission_id = $_GET['id'] ?? 0;
                $view_stmt = $pdo->prepare("
                    SELECT s.*, j.name as journal_name
                    FROM submissions s
                    LEFT JOIN journals j ON s.journal_id = j.id
                    WHERE s.id = ? AND s.author_id = ?
                ");
                $view_stmt->execute([$submission_id, $user_id]);
                $submission = $view_stmt->fetch(PDO::FETCH_ASSOC);
             
                if (!$submission):
                ?>
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                        Submission not found or you don't have permission to view it.
                    </div>
                <?php else:
                    $authors = json_decode($submission['authors'], true) ?? [];
                    $corresponding = json_decode($submission['corresponding_author'], true) ?? [];
                ?>
                    <div class="bg-white rounded-lg shadow-md p-6">
                        <div class="flex justify-between items-start mb-6">
                            <h2 class="text-2xl font-semibold text-gray-800">Submission Details</h2>
                            <a href="?section=submissions" class="text-blue-600 hover:text-blue-800">
                                <i class="fas fa-arrow-left mr-2"></i>Back to Submissions
                            </a>
                        </div>
                     
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-600 mb-2">Tracking Code</label>
                                <p class="text-lg font-mono text-gray-800"><?php echo htmlspecialchars($submission['tracking_code']); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-600 mb-2">Status</label>
                                <span class="status-badge status-<?php echo strtolower($submission['status']); ?>">
                                    <?php echo ucfirst(str_replace('_', ' ', $submission['status'])); ?>
                                </span>
                            </div>
                        </div>
                     
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Journal</label>
                            <p class="text-lg text-gray-800"><?php echo htmlspecialchars($submission['journal_name'] ?? 'N/A'); ?></p>
                        </div>
                     
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Title</label>
                            <p class="text-lg text-gray-800"><?php echo htmlspecialchars($submission['title']); ?></p>
                        </div>
                     
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Abstract</label>
                            <p class="text-gray-700 leading-relaxed"><?php echo nl2br(htmlspecialchars($submission['abstract'])); ?></p>
                        </div>
                     
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Keywords</label>
                            <p class="text-gray-700"><?php echo htmlspecialchars($submission['keywords']); ?></p>
                        </div>
                     
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Authors</label>
                            <?php if (!empty($authors)): ?>
                                <ul class="list-disc pl-5 space-y-1">
                                    <?php foreach ($authors as $author): ?>
                                        <li class="text-gray-700">
                                            <?php echo htmlspecialchars($author['name']); ?>
                                            <span class="text-gray-500 text-sm">(<?php echo htmlspecialchars($author['affiliation']); ?>)</span>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                     
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Corresponding Author</label>
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <p class="text-gray-800"><strong>Name:</strong> <?php echo htmlspecialchars($corresponding['name'] ?? 'N/A'); ?></p>
                                <p class="text-gray-800"><strong>Email:</strong> <?php echo htmlspecialchars($corresponding['email'] ?? 'N/A'); ?></p>
                                <p class="text-gray-800"><strong>Organization:</strong> <?php echo htmlspecialchars($corresponding['organisation'] ?? 'N/A'); ?></p>
                                <p class="text-gray-800"><strong>Country:</strong> <?php echo htmlspecialchars($corresponding['country'] ?? 'N/A'); ?></p>
                            </div>
                        </div>
                     
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Submission Details</label>
                            <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                                <div class="bg-gray-50 p-3 rounded">
                                    <p class="text-sm text-gray-600">Desired Issue</p>
                                    <p class="text-lg font-semibold text-gray-800"><?php echo ucfirst($submission['desired_issue']); ?></p>
                                </div>
                                <div class="bg-gray-50 p-3 rounded">
                                    <p class="text-sm text-gray-600">Total Authors</p>
                                    <p class="text-lg font-semibold text-gray-800"><?php echo $submission['total_authors']; ?></p>
                                </div>
                                <div class="bg-gray-50 p-3 rounded">
                                    <p class="text-sm text-gray-600">Number of Pages</p>
                                    <p class="text-lg font-semibold text-gray-800"><?php echo $submission['num_pages']; ?></p>
                                </div>
                            </div>
                        </div>
                     
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Submission Date</label>
                            <p class="text-lg text-gray-800"><?php echo date('F d, Y g:i A', strtotime($submission['submitted_at'])); ?></p>
                        </div>
                     
                        <?php if ($submission['file_url']): ?>
                            <div class="mb-6">
                                <label class="block text-sm font-medium text-gray-600 mb-2">Manuscript File</label>
                                <a href="../../common/author/<?php echo htmlspecialchars($submission['file_url']); ?>" target="_blank" class="inline-block bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700">
                                    <i class="fas fa-download mr-2"></i>Download Manuscript
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </main>
    </div>
    <!-- MOVED MODAL HERE: Final Submission Modal (outside loop, always rendered once when section=submissions) -->
    <?php if ($active_section === 'submissions'): ?>
    <!-- Final Submission Modal -->
    <div id="finalSubmissionModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <span class="close" onclick="closeFinalSubmissionModal()">&times;</span>
                <h2 class="text-2xl font-bold">
                    <i class="fas fa-file-upload mr-2"></i>Final Submission
                </h2>
                <p class="text-sm opacity-90 mt-2">Upload your payment receipt, declaration form, and final manuscript</p>
            </div>
         
            <form id="finalSubmissionForm" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" id="modal_submission_id" name="submission_id">
                    <input type="hidden" id="modal_tracking_code" name="tracking_code">
                 
                    <div id="final-submission-message"></div>
                 
                    <!-- Info Box -->
                    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-6">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <i class="fas fa-info-circle text-blue-500 text-xl"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-blue-700">
                                    <strong>Important:</strong> You can upload files in any order. Once a file is submitted,
                                    it cannot be changed. You may submit files one at a time or all at once.
                                </p>
                            </div>
                        </div>
                    </div>
                 
                    <!-- Payment Receipt Upload -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-receipt text-green-600 mr-2"></i>Payment Receipt
                            <span id="payment_receipt_status"></span>
                        </label>
                        <div class="file-upload-box" id="payment_receipt_box">
                            <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-2"></i>
                            <p class="text-sm text-gray-600 mb-2">Click to upload or drag and drop</p>
                            <p class="text-xs text-gray-500">PDF, JPG, PNG (Max 5MB)</p>
                            <input type="file"
                                   id="payment_receipt"
                                   name="payment_receipt"
                                   accept=".pdf,.jpg,.jpeg,.png"
                                   class="hidden"
                                   onchange="handleFileSelect(this, 'payment_receipt')">
                            <button type="button"
                                    onclick="document.getElementById('payment_receipt').click()"
                                    class="mt-3 bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                                Choose File
                            </button>
                            <div id="payment_receipt_info" class="hidden uploaded-file-info">
                                <span class="text-sm"><i class="fas fa-file mr-2"></i><span id="payment_receipt_name"></span></span>
                                <button type="button" onclick="removeFile('payment_receipt')" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-times-circle"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                 
                    <!-- Declaration Form Upload -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-file-signature text-purple-600 mr-2"></i>Declaration Form
                            <span id="declaration_form_status"></span>
                        </label>
                        <div class="file-upload-box" id="declaration_form_box">
                            <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-2"></i>
                            <p class="text-sm text-gray-600 mb-2">Click to upload or drag and drop</p>
                            <p class="text-xs text-gray-500">PDF, DOC, DOCX (Max 5MB)</p>
                            <input type="file"
                                   id="declaration_form"
                                   name="declaration_form"
                                   accept=".pdf,.doc,.docx"
                                   class="hidden"
                                   onchange="handleFileSelect(this, 'declaration_form')">
                            <button type="button"
                                    onclick="document.getElementById('declaration_form').click()"
                                    class="mt-3 bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                                Choose File
                            </button>
                            <div id="declaration_form_info" class="hidden uploaded-file-info">
                                <span class="text-sm"><i class="fas fa-file mr-2"></i><span id="declaration_form_name"></span></span>
                                <button type="button" onclick="removeFile('declaration_form')" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-times-circle"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                 
                    <!-- Final Manuscript Upload -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-file-alt text-blue-600 mr-2"></i>Final Manuscript
                            <span id="final_manuscript_status"></span>
                        </label>
                        <div class="file-upload-box" id="final_manuscript_box">
                            <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-2"></i>
                            <p class="text-sm text-gray-600 mb-2">Click to upload or drag and drop</p>
                            <p class="text-xs text-gray-500">PDF, DOC, DOCX (Max 5MB)</p>
                            <input type="file"
                                   id="final_manuscript"
                                   name="final_manuscript"
                                   accept=".pdf,.doc,.docx"
                                   class="hidden"
                                   onchange="handleFileSelect(this, 'final_manuscript')">
                            <button type="button"
                                    onclick="document.getElementById('final_manuscript').click()"
                                    class="mt-3 bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                                Choose File
                            </button>
                            <div id="final_manuscript_info" class="hidden uploaded-file-info">
                                <span class="text-sm"><i class="fas fa-file mr-2"></i><span id="final_manuscript_name"></span></span>
                                <button type="button" onclick="removeFile('final_manuscript')" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-times-circle"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
         
                <div class="modal-footer">
                    <button type="button"
                            onclick="closeFinalSubmissionModal()"
                            class="bg-gray-500 text-white px-6 py-2 rounded hover:bg-gray-600">
                        Cancel
                    </button>
                    <button type="submit"
                            id="submitFinalBtn"
                            class="bg-gradient-to-r from-purple-600 to-indigo-600 text-white px-6 py-2 rounded hover:from-purple-700 hover:to-indigo-700 font-semibold">
                        <i class="fas fa-upload mr-2"></i>Submit Files
                    </button>
                </div>
            </form>
        </div>
    </div>
    <!-- Resubmit Manuscript Modal -->
    <div id="resubmitModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <span class="close" onclick="closeResubmitModal()">&times;</span>
                <h2 class="text-2xl font-bold">
                    <i class="fas fa-redo mr-2"></i>Resubmit Revised Manuscript
                </h2>
                <p class="text-sm opacity-90 mt-2">Upload your revised manuscript file based on the editor's feedback</p>
            </div>
         
            <form id="resubmitForm" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" id="resubmit_submission_id" name="submission_id">
                 
                    <div id="resubmit-message"></div>
                 
                    <!-- Info Box -->
                    <div class="bg-orange-50 border-l-4 border-orange-500 p-4 mb-6">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <i class="fas fa-info-circle text-orange-500 text-xl"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-orange-700">
                                    <strong>Important:</strong> Please ensure your revisions address the editor's comments. The file will be saved as the resubmission and your status will be updated to "Submitted".
                                </p>
                            </div>
                        </div>
                    </div>
                 
                    <!-- Revised Manuscript Upload -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-file-alt text-orange-600 mr-2"></i>Revised Manuscript File <span class="text-red-500">*</span>
                            <span id="resubmit_file_status"></span>
                        </label>
                        <div class="file-upload-box" id="resubmit_file_box">
                            <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-2"></i>
                            <p class="text-sm text-gray-600 mb-2">Click to upload or drag and drop</p>
                            <p class="text-xs text-gray-500">DOC, DOCX, RTF (Max 5MB)</p>
                            <input type="file"
                                   id="resubmit_file"
                                   name="resubmission_file"
                                   accept=".doc,.docx,.rtf"
                                   class="hidden"
                                   required
                                   onchange="handleResubmitFileSelect(this)">
                            <button type="button"
                                    onclick="document.getElementById('resubmit_file').click()"
                                    class="mt-3 bg-orange-500 text-white px-4 py-2 rounded hover:bg-orange-600">
                                Choose Revised File
                            </button>
                            <div id="resubmit_file_info" class="hidden uploaded-file-info">
                                <span class="text-sm"><i class="fas fa-file mr-2"></i><span id="resubmit_file_name"></span></span>
                                <button type="button" onclick="removeResubmitFile()" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-times-circle"></i>
                                </button>
                            </div>
                        </div>
                        <p class="text-xs text-gray-500 mt-1">Allowed formats: .doc, .docx, .rtf (Max 5MB)</p>
                    </div>
                </div>
         
                <div class="modal-footer">
                    <button type="button"
                            onclick="closeResubmitModal()"
                            class="bg-gray-500 text-white px-6 py-2 rounded hover:bg-gray-600">
                        Cancel
                    </button>
                    <button type="submit"
                            id="submitResubmitBtn"
                            class="bg-gradient-to-r from-orange-600 to-red-600 text-white px-6 py-2 rounded hover:from-orange-700 hover:to-red-700 font-semibold">
                        <i class="fas fa-redo mr-2"></i>Resubmit File
                    </button>
                </div>
            </form>
        </div>
    </div>
    <?php endif; // END conditional for modal rendering only on submissions section ?>
    <!-- END MOVED MODAL -->
    <script>
        // Mobile Menu Toggle
        document.getElementById('mobileMenuBtn')?.addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('mobile-open');
        });
        // Sidebar Toggle
        document.getElementById('toggleSidebar').addEventListener('click', function() {
            const sidebar = document.getElementById('sidebar');
            const content = document.getElementById('content');
            sidebar.classList.toggle('collapsed');
            content.classList.toggle('expanded');
        });
        // Generate author fields dynamically
        function generateAuthorFields(count) {
            const container = document.getElementById('authors-container');
            container.innerHTML = '';
         
            for (let i = 1; i <= count; i++) {
                const authorDiv = document.createElement('div');
                authorDiv.className = 'bg-gray-50 p-4 rounded-lg mb-4';
             
                const ordinal = getOrdinal(i);
             
                authorDiv.innerHTML = `
                    <h4 class="font-semibold text-gray-800 mb-3">${ordinal} Author</h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                ${ordinal} Author Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="author_name[]" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                ${ordinal} Author Affiliation <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="author_affiliation[]" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                    </div>
                `;
             
                container.appendChild(authorDiv);
            }
        }
     
        function getOrdinal(n) {
            const s = ["th", "st", "nd", "rd"];
            const v = n % 100;
            return n + (s[(v - 20) % 10] || s[v] || s[0]);
        }
     
        // Initialize with 1 author field
        if (document.getElementById('total_authors')) {
            generateAuthorFields(1);
         
            document.getElementById('total_authors').addEventListener('input', function() {
                const count = parseInt(this.value) || 1;
                if (count >= 1 && count <= 20) {
                    generateAuthorFields(count);
                }
            });
        }
        // Form submission
        document.getElementById('newSubmissionForm')?.addEventListener('submit', async function(e) {
            e.preventDefault();
         
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Submitting...';
         
            try {
                const formData = new FormData(this);
                formData.append('action', 'submit');
             
                const response = await fetch('process_author_submission.php', {
                    method: 'POST',
                    body: formData
                });
             
                const result = await response.json();
             
                const messageDiv = document.getElementById('submission-message');
                if (result.success) {
                    messageDiv.innerHTML = `
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                            <p class="font-semibold">${result.message}</p>
                            <p class="mt-2">Your tracking code is: <strong>${result.tracking_code}</strong></p>
                        </div>
                    `;
                    this.reset();
                    generateAuthorFields(1);
                    window.scrollTo(0, 0);
                 
                    // Redirect to submissions after 3 seconds
                    setTimeout(() => {
                        window.location.href = '?section=submissions';
                    }, 3000);
                } else {
                    messageDiv.innerHTML = `
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                            Error: ${result.message}
                        </div>
                    `;
                    window.scrollTo(0, 0);
                }
            } catch (error) {
                document.getElementById('submission-message').innerHTML = `
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                        Error: ${error.message}
                    </div>
                `;
                window.scrollTo(0, 0);
            } finally {
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            }
        });
        // Save as draft
        document.getElementById('saveDraftBtn')?.addEventListener('click', async function() {
            const form = document.getElementById('newSubmissionForm');
            const originalText = this.innerHTML;
            this.disabled = true;
            this.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Saving...';
         
            try {
                const formData = new FormData(form);
                formData.append('action', 'draft');
             
                const response = await fetch('process_author_submission.php', {
                    method: 'POST',
                    body: formData
                });
             
                const result = await response.json();
             
                const messageDiv = document.getElementById('submission-message');
                if (result.success) {
                    messageDiv.innerHTML = `
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                            ${result.message}
                        </div>
                    `;
                    window.scrollTo(0, 0);
                } else {
                    messageDiv.innerHTML = `
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                            Error: ${result.message}
                        </div>
                    `;
                    window.scrollTo(0, 0);
                }
            } catch (error) {
                document.getElementById('submission-message').innerHTML = `
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                        Error: ${error.message}
                    </div>
                `;
                window.scrollTo(0, 0);
            } finally {
                this.disabled = false;
                this.innerHTML = originalText;
            }
        });
    </script>
    <script>
    // Handle ticket submission
document.getElementById('raiseTicketForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
 
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Submitting...';
 
    try {
        const formData = new FormData(this);
     
        const response = await fetch('process_author_ticket.php', {
            method: 'POST',
            body: formData
        });
     
        const result = await response.json();
     
        const messageDiv = document.getElementById('ticket-message');
        if (result.success) {
            messageDiv.innerHTML = `
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                    <p class="font-semibold">${result.message}</p>
                    <p class="mt-2">Your ticket number is: <strong>${result.ticket_number}</strong></p>
                </div>
            `;
            this.reset();
            window.scrollTo(0, 0);
         
            // Redirect to tickets after 2 seconds
            setTimeout(() => {
                window.location.href = '?section=tickets';
            }, 2000);
        } else {
            messageDiv.innerHTML = `
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                    Error: ${result.message}
                </div>
            `;
            window.scrollTo(0, 0);
        }
    } catch (error) {
        document.getElementById('ticket-message').innerHTML = `
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                Error: ${error.message}
            </div>
        `;
        window.scrollTo(0, 0);
    } finally {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    }
});
    </script>
    <script>
    // Reply to Ticket Form Submission
document.getElementById('replyTicketForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
 
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Sending...';
 
    try {
        const formData = new FormData(this);
        const ticketId = this.dataset.ticketId;
        formData.append('ticket_id', ticketId);
        formData.append('action', 'reply');
     
        const response = await fetch('process_author_ticket.php', {
            method: 'POST',
            body: formData
        });
     
        const result = await response.json();
     
        const messageDiv = document.getElementById('reply-message');
        if (result.success) {
            messageDiv.innerHTML = `
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    ${result.message}
                </div>
            `;
         
            // Reload page to show new reply
            setTimeout(() => {
                location.reload();
            }, 1000);
        } else {
            messageDiv.innerHTML = `
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    Error: ${result.message}
                </div>
            `;
        }
    } catch (error) {
        document.getElementById('reply-message').innerHTML = `
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                Error: ${error.message}
            </div>
        `;
    } finally {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    }
});
    </script>
 
    <!--=================================================================================-->
    <script>
// Final Submission Modal Functions
let existingFinalSubmission = null;
function openFinalSubmissionModal(submissionId, trackingCode, hasExisting) {
    document.getElementById('modal_submission_id').value = submissionId;
    document.getElementById('modal_tracking_code').value = trackingCode;
    document.getElementById('finalSubmissionModal').style.display = 'block';
    document.getElementById('final-submission-message').innerHTML = '';
 
    // Reset all file inputs and displays
    resetFileInputs();
 
    // If there's an existing submission, fetch and display the status
    if (hasExisting) {
        fetchExistingSubmission(submissionId);
    }
}
function closeFinalSubmissionModal() {
    document.getElementById('finalSubmissionModal').style.display = 'none';
    resetFileInputs();
}
function resetFileInputs() {
    const fields = ['payment_receipt', 'declaration_form', 'final_manuscript'];
    fields.forEach(field => {
        document.getElementById(field).value = '';
        document.getElementById(field + '_box').classList.remove('uploaded', 'disabled');
        document.getElementById(field + '_info').classList.add('hidden');
        document.getElementById(field + '_status').innerHTML = '';
        document.getElementById(field).disabled = false;
        const button = document.getElementById(field + '_box').querySelector('button');
        if (button) button.disabled = false;
    });
}
async function fetchExistingSubmission(submissionId) {
    try {
        const response = await fetch('get_final_submission_status.php?submission_id=' + submissionId);
        const result = await response.json();
     
        if (result.success && result.data) {
            existingFinalSubmission = result.data;
         
            // Mark uploaded files and disable them
            const fields = ['payment_receipt', 'declaration_form', 'final_manuscript'];
            fields.forEach(field => {
                if (result.data[field]) {
                    markFileAsUploaded(field, result.data[field]);
                }
            });
         
            // Show info message
            if (result.data.is_complete) {
                document.getElementById('final-submission-message').innerHTML = `
                    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                        <i class="fas fa-check-circle mr-2"></i>All files have been submitted successfully!
                    </div>
                `;
                document.getElementById('submitFinalBtn').disabled = true;
                document.getElementById('submitFinalBtn').classList.add('opacity-50', 'cursor-not-allowed');
            } else {
                document.getElementById('final-submission-message').innerHTML = `
                    <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded mb-4">
                        <i class="fas fa-info-circle mr-2"></i>Some files are pending. You can upload the remaining files.
                    </div>
                `;
            }
        }
    } catch (error) {
        console.error('Error fetching submission status:', error);
    }
}
function markFileAsUploaded(fieldName, filePath) {
    const box = document.getElementById(fieldName + '_box');
    const input = document.getElementById(fieldName);
    const status = document.getElementById(fieldName + '_status');
    const button = box.querySelector('button');
 
    // Add visual indicators
    box.classList.add('disabled');
    box.classList.remove('uploaded');
    input.disabled = true;
    if (button) button.disabled = true;
 
    // Show status
    status.innerHTML = '<span class="text-green-600 text-xs ml-2"><i class="fas fa-check-circle"></i> Already Submitted</span>';
 
    // Add view link
    const fileName = filePath.split('/').pop();
    box.innerHTML = `
        <div class="text-center">
            <i class="fas fa-check-circle text-green-500 text-4xl mb-2"></i>
            <p class="text-sm text-green-700 font-semibold mb-2">File Already Submitted</p>
            <a href="../../common/author/${filePath}" target="_blank" class="text-blue-600 hover:underline text-sm">
                <i class="fas fa-eye mr-1"></i>View File
            </a>
            <p class="text-xs text-gray-500 mt-2">This file cannot be changed</p>
        </div>
    `;
}
function handleFileSelect(input, fieldName) {
    if (input.files && input.files[0]) {
        const file = input.files[0];
        const maxSize = 5 * 1024 * 1024; // 5MB
     
        if (file.size > maxSize) {
            alert('File size exceeds 5MB limit');
            input.value = '';
            return;
        }
     
        // Show file info
        document.getElementById(fieldName + '_box').classList.add('uploaded');
        document.getElementById(fieldName + '_info').classList.remove('hidden');
        document.getElementById(fieldName + '_name').textContent = file.name;
    }
}
function removeFile(fieldName) {
    document.getElementById(fieldName).value = '';
    document.getElementById(fieldName + '_box').classList.remove('uploaded');
    document.getElementById(fieldName + '_info').classList.add('hidden');
}
// Handle form submission
document.getElementById('finalSubmissionForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
 
    const submitBtn = document.getElementById('submitFinalBtn');
    const originalText = submitBtn.innerHTML;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Uploading...';
 
    try {
        const formData = new FormData(this);
     
        // Check if at least one file is selected
        let hasFile = false;
        const fields = ['payment_receipt', 'declaration_form', 'final_manuscript'];
        fields.forEach(field => {
            if (document.getElementById(field).files.length > 0) {
                hasFile = true;
            }
        });
     
        if (!hasFile) {
            document.getElementById('final-submission-message').innerHTML = `
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <i class="fas fa-exclamation-triangle mr-2"></i>Please select at least one file to upload
                </div>
            `;
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalText;
            return;
        }
     
        const response = await fetch('process_final_submission.php', {
            method: 'POST',
            body: formData
        });
     
        const result = await response.json();
     
        const messageDiv = document.getElementById('final-submission-message');
        if (result.success) {
            messageDiv.innerHTML = `
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <i class="fas fa-check-circle mr-2"></i>${result.message}
                </div>
            `;
         
            // Reload page after 2 seconds if complete
            if (result.is_complete) {
                setTimeout(() => {
                    location.reload();
                }, 2000);
            } else {
                // Refresh the modal to show updated status
                setTimeout(() => {
                    const submissionId = document.getElementById('modal_submission_id').value;
                    fetchExistingSubmission(submissionId);
                }, 1000);
            }
        } else {
            messageDiv.innerHTML = `
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <i class="fas fa-exclamation-triangle mr-2"></i>${result.message}
                </div>
            `;
        }
    } catch (error) {
        document.getElementById('final-submission-message').innerHTML = `
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <i class="fas fa-exclamation-triangle mr-2"></i>Error: ${error.message}
            </div>
        `;
    } finally {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    }
});
// Close modal when clicking outside
window.onclick = function(event) {
    const modal = document.getElementById('finalSubmissionModal');
    if (event.target == modal) {
        closeFinalSubmissionModal();
    }
}
// Resubmit Modal Functions
function openResubmitModal(submissionId) {
    document.getElementById('resubmit_submission_id').value = submissionId;
    document.getElementById('resubmitModal').style.display = 'block';
    document.getElementById('resubmit-message').innerHTML = '';
    resetResubmitFileInput();
}
function closeResubmitModal() {
    document.getElementById('resubmitModal').style.display = 'none';
    resetResubmitFileInput();
}
function resetResubmitFileInput() {
    const fileInput = document.getElementById('resubmit_file');
    const box = document.getElementById('resubmit_file_box');
    const info = document.getElementById('resubmit_file_info');
    const status = document.getElementById('resubmit_file_status');
    const button = box.querySelector('button');
    fileInput.value = '';
    box.classList.remove('uploaded');
    info.classList.add('hidden');
    status.innerHTML = '';
    fileInput.required = true;
    if (button) button.disabled = false;
}
function handleResubmitFileSelect(input) {
    if (input.files && input.files[0]) {
        const file = input.files[0];
        const maxSize = 5 * 1024 * 1024; // 5MB
        if (file.size > maxSize) {
            alert('File size exceeds 5MB limit');
            input.value = '';
            return;
        }
        // Show file info
        document.getElementById('resubmit_file_box').classList.add('uploaded');
        document.getElementById('resubmit_file_info').classList.remove('hidden');
        document.getElementById('resubmit_file_name').textContent = file.name;
        document.getElementById('resubmit_file').required = false; // No longer required once selected
    }
}
function removeResubmitFile() {
    resetResubmitFileInput();
}
// Handle resubmit form submission
document.getElementById('resubmitForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    const fileInput = document.getElementById('resubmit_file');
    if (!fileInput.files || fileInput.files.length === 0) {
        document.getElementById('resubmit-message').innerHTML = `
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <i class="fas fa-exclamation-triangle mr-2"></i>Please select a revised manuscript file
            </div>
        `;
        return;
    }
    const submitBtn = document.getElementById('submitResubmitBtn');
    const originalText = submitBtn.innerHTML;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Resubmitting...';
    try {
        const formData = new FormData(this);
        const response = await fetch('process_resubmission.php', {
            method: 'POST',
            body: formData
        });
        const result = await response.json();
        const messageDiv = document.getElementById('resubmit-message');
        if (result.success) {
            messageDiv.innerHTML = `
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <i class="fas fa-check-circle mr-2"></i>${result.message}
                </div>
            `;
            // Reload page after 2 seconds
            setTimeout(() => {
                location.reload();
            }, 2000);
        } else {
            messageDiv.innerHTML = `
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <i class="fas fa-exclamation-triangle mr-2"></i>${result.message}
                </div>
            `;
        }
    } catch (error) {
        document.getElementById('resubmit-message').innerHTML = `
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <i class="fas fa-exclamation-triangle mr-2"></i>Error: ${error.message}
            </div>
        `;
    } finally {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    }
});
// Close resubmit modal when clicking outside
document.addEventListener('click', function(event) {
    const modal = document.getElementById('resubmitModal');
    if (event.target === modal) {
        closeResubmitModal();
    }
});
</script>
</body>
</html>