<?php
session_start();
header('Content-Type: application/json');

// Database configuration
$db_host = 'localhost';
$db_user = 'rsisinternation1_new_journal_flo';
$db_pass = 'weDCVrG3$%fv78T';
$db_name = 'rsisinternation1_new_journal_flow';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit();
}

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'author') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

$user_id = $_SESSION['user_id'];
$submission_id = $_GET['submission_id'] ?? 0;

if (!$submission_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid submission ID']);
    exit();
}

try {
    // Verify submission belongs to this author
    $verify_stmt = $pdo->prepare("SELECT id FROM submissions WHERE id = ? AND author_id = ?");
    $verify_stmt->execute([$submission_id, $user_id]);
    
    if (!$verify_stmt->fetch()) {
        echo json_encode(['success' => false, 'message' => 'Invalid submission or unauthorized access']);
        exit();
    }
    
    // Get final submission data
    $stmt = $pdo->prepare("
        SELECT * FROM final_submissions 
        WHERE submission_id = ? AND author_id = ?
    ");
    $stmt->execute([$submission_id, $user_id]);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($data) {
        echo json_encode([
            'success' => true,
            'data' => $data
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'No submission found',
            'data' => null
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>