<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../../error.log');
error_reporting(E_ALL);

header('Content-Type: application/json');

session_start();

// Check authentication
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'author') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

// Database configuration
// $db_host = 'localhost';
// $db_user = 'rsisinternation1_newusersirsis';
// $db_pass = '?*!IMRQQ=-h.JQ(u';
// $db_name = 'rsisinternation1_SInewJournal';
// Database configuration - SAME AS ADMIN
$db_host = 'localhost';
$db_user = 'rsisinternation1_new_journal_flo';
$db_pass = 'weDCVrG3$%fv78T';
$db_name = 'rsisinternation1_new_journal_flow';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$author_id = $_SESSION['user_id'];
$action = $_POST['action'] ?? 'create';

try {
    if ($action === 'reply') {
        // Handle ticket reply
        $ticket_id = intval($_POST['ticket_id'] ?? 0);
        $reply_message = trim($_POST['reply_message'] ?? '');
        
        if (empty($reply_message)) {
            throw new Exception('Reply message is required');
        }
        
        // Verify ticket belongs to author
        $verify_stmt = $pdo->prepare("SELECT id, status, subject, ticket_number FROM author_tickets WHERE id = ? AND author_id = ?");
        $verify_stmt->execute([$ticket_id, $author_id]);
        $ticket = $verify_stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$ticket) {
            throw new Exception('Ticket not found or you do not have permission');
        }
        
        if ($ticket['status'] === 'closed') {
            throw new Exception('Cannot reply to a closed ticket');
        }
        
        // Insert reply
        $reply_stmt = $pdo->prepare("
            INSERT INTO ticket_replies (ticket_id, user_id, message, is_admin, created_at)
            VALUES (?, ?, ?, 0, NOW())
        ");
        $reply_stmt->execute([$ticket_id, $author_id, $reply_message]);
        
        // Update ticket status to 'open' if it was resolved
        if ($ticket['status'] === 'resolved') {
            $update_stmt = $pdo->prepare("UPDATE author_tickets SET status = 'open', updated_at = NOW() WHERE id = ?");
            $update_stmt->execute([$ticket_id]);
        } else {
            // Just update the updated_at timestamp
            $update_stmt = $pdo->prepare("UPDATE author_tickets SET updated_at = NOW() WHERE id = ?");
            $update_stmt->execute([$ticket_id]);
        }
        
        // Send email notification to admin
        $admin_email = "support@rsisinternational.org";
        $admin_subject = "New Reply on Ticket - " . $ticket['ticket_number'];
        
        $admin_message = "
        <html>
        <body style='font-family: Arial, sans-serif;'>
            <h2>New Author Reply on Ticket</h2>
            <p><strong>Ticket Number:</strong> " . htmlspecialchars($ticket['ticket_number']) . "</p>
            <p><strong>Subject:</strong> " . htmlspecialchars($ticket['subject']) . "</p>
            <p><strong>Author Reply:</strong></p>
            <p>" . nl2br(htmlspecialchars($reply_message)) . "</p>
            <p><a href='https://rsisinternational.org/journals/admin/view_ticket.php?id=" . $ticket_id . "'>View and Respond in Admin Panel</a></p>
        </body>
        </html>
        ";
        
        $admin_headers = "MIME-Version: 1.0" . "\r\n";
        $admin_headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $admin_headers .= "From: RSIS Ticket System <noreply@rsisinternational.org>" . "\r\n";
        
        mail($admin_email, $admin_subject, $admin_message, $admin_headers);
        
        echo json_encode([
            'success' => true,
            'message' => 'Reply sent successfully!'
        ]);
        
    } else {
        // Handle new ticket creation
        $submission_id = !empty($_POST['submission_id']) ? intval($_POST['submission_id']) : null;
        $subject = trim($_POST['subject'] ?? '');
        $message = trim($_POST['message'] ?? '');
        $priority = trim($_POST['priority'] ?? 'medium');
        
        // Validate required fields
        if (empty($subject)) {
            throw new Exception('Subject is required');
        }
        
        if (empty($message)) {
            throw new Exception('Message is required');
        }
        
        // Validate priority
        $valid_priorities = ['low', 'medium', 'high', 'urgent'];
        if (!in_array($priority, $valid_priorities)) {
            $priority = 'medium';
        }
        
        // If submission_id is provided, verify it belongs to the author
        if ($submission_id !== null) {
            $verify_stmt = $pdo->prepare("SELECT id FROM submissions WHERE id = ? AND author_id = ?");
            $verify_stmt->execute([$submission_id, $author_id]);
            if (!$verify_stmt->fetch()) {
                throw new Exception('Invalid submission selected');
            }
        }
        
        // Generate unique ticket number
        $ticket_number = 'TKT-' . date('Y') . date('m') . '-' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT);
        
        // Check if ticket number already exists
        $check_stmt = $pdo->prepare("SELECT id FROM author_tickets WHERE ticket_number = ?");
        $check_stmt->execute([$ticket_number]);
        while ($check_stmt->fetch()) {
            $ticket_number = 'TKT-' . date('Y') . date('m') . '-' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT);
            $check_stmt->execute([$ticket_number]);
        }
        
        // Insert ticket
        $insert_stmt = $pdo->prepare("
            INSERT INTO author_tickets (
                ticket_number,
                author_id,
                submission_id,
                subject,
                message,
                priority,
                status,
                created_at
            ) VALUES (?, ?, ?, ?, ?, ?, 'open', NOW())
        ");
        
        $insert_stmt->execute([
            $ticket_number,
            $author_id,
            $submission_id,
            $subject,
            $message,
            $priority
        ]);
        
        $ticket_id = $pdo->lastInsertId();
        
        // Fetch author email for notification
        $user_stmt = $pdo->prepare("SELECT email, username, first_name, last_name FROM users WHERE id = ?");
        $user_stmt->execute([$author_id]);
        $user = $user_stmt->fetch(PDO::FETCH_ASSOC);
        
        // Send email notification to author
        if ($user && !empty($user['email'])) {
            $to = $user['email'];
            $email_subject = "Ticket Created Successfully - " . $ticket_number;
            
            $author_name = trim(($user['first_name'] ?? '') . ' ' . ($user['last_name'] ?? ''));
            if (empty($author_name)) {
                $author_name = $user['username'];
            }
            
            $email_message = "
            <html>
            <head>
                <style>
                    body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                    .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                    .header { background: #003366; color: white; padding: 20px; text-align: center; }
                    .content { padding: 20px; background: #f9f9f9; }
                    .ticket-box { background: white; padding: 15px; margin: 20px 0; border-left: 4px solid #3b82f6; }
                    .button { display: inline-block; padding: 12px 30px; background: #003366; color: white; text-decoration: none; border-radius: 4px; margin: 20px 0; }
                    .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='header'>
                        <h2>Ticket Confirmation</h2>
                    </div>
                    <div class='content'>
                        <p>Dear " . htmlspecialchars($author_name) . ",</p>
                        
                        <p>Your support ticket has been created successfully.</p>
                        
                        <div class='ticket-box'>
                            <p><strong>Ticket Number:</strong> " . htmlspecialchars($ticket_number) . "</p>
                            <p><strong>Subject:</strong> " . htmlspecialchars($subject) . "</p>
                            <p><strong>Priority:</strong> " . ucfirst(htmlspecialchars($priority)) . "</p>
                            <p><strong>Status:</strong> Open</p>
                        </div>
                        
                        <p><strong>Your Message:</strong></p>
                        <p>" . nl2br(htmlspecialchars($message)) . "</p>
                        
                        <p>Our support team will review your ticket and respond as soon as possible.</p>
                        
                        <a href='https://rsisinternational.org/journals/common/author/author_dashboard.php?section=tickets' class='button'>View My Tickets</a>
                        
                        <p>Best regards,<br>
                        RSIS International Support Team</p>
                    </div>
                    <div class='footer'>
                        <p>&copy; " . date('Y') . " RSIS International. All rights reserved.</p>
                    </div>
                </div>
            </body>
            </html>
            ";
            
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $headers .= "From: RSIS International Support <support@rsisinternational.org>" . "\r\n";
            $headers .= "Reply-To: support@rsisinternational.org" . "\r\n";
            
            mail($to, $email_subject, $email_message, $headers);
        }
        
        // Send notification email to admin
        $admin_email = "support@rsisinternational.org";
        $admin_subject = "New Support Ticket - " . $ticket_number;
        
        $admin_message = "
        <html>
        <body style='font-family: Arial, sans-serif;'>
            <h2>New Support Ticket Received</h2>
            <p><strong>Ticket Number:</strong> " . htmlspecialchars($ticket_number) . "</p>
            <p><strong>Author:</strong> " . htmlspecialchars($author_name) . " (" . htmlspecialchars($user['email']) . ")</p>
            <p><strong>Subject:</strong> " . htmlspecialchars($subject) . "</p>
            <p><strong>Priority:</strong> " . ucfirst(htmlspecialchars($priority)) . "</p>
            <p><strong>Message:</strong></p>
            <p>" . nl2br(htmlspecialchars($message)) . "</p>
            <p><a href='https://rsisinternational.org/journals/admin/view_ticket.php?id=" . $ticket_id . "'>View in Admin Panel</a></p>
        </body>
        </html>
        ";
        
        $admin_headers = "MIME-Version: 1.0" . "\r\n";
        $admin_headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $admin_headers .= "From: RSIS Ticket System <noreply@rsisinternational.org>" . "\r\n";
        
        mail($admin_email, $admin_subject, $admin_message, $admin_headers);
        
        echo json_encode([
            'success' => true,
            'message' => 'Ticket created successfully! A confirmation email has been sent.',
            'ticket_number' => $ticket_number,
            'ticket_id' => $ticket_id
        ]);
    }
    
} catch (Exception $e) {
    error_log('Ticket Processing Error: ' . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>