<?php
session_start();
header('Content-Type: application/json');
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 0); // Don't display errors in JSON response
ini_set('log_errors', 1);
// Database configuration
$db_host = 'localhost';
$db_user = 'rsisinternation1_new_journal_flo';
$db_pass = 'weDCVrG3$%fv78T';
$db_name = 'rsisinternation1_new_journal_flow';
try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}
// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'author') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}
$user_id = $_SESSION['user_id'];
$submission_id = $_POST['submission_id'] ?? 0;
$tracking_code = $_POST['tracking_code'] ?? '';
if (!$submission_id || !$tracking_code) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit();
}
// Verify submission belongs to this author
$verify_stmt = $pdo->prepare("SELECT id FROM submissions WHERE id = ? AND author_id = ?");
$verify_stmt->execute([$submission_id, $user_id]);
if (!$verify_stmt->fetch()) {
    echo json_encode(['success' => false, 'message' => 'Invalid submission']);
    exit();
}
// Check if final submission already exists
$check_stmt = $pdo->prepare("SELECT * FROM final_submissions WHERE submission_id = ? AND author_id = ?");
$check_stmt->execute([$submission_id, $user_id]);
$existing_submission = $check_stmt->fetch(PDO::FETCH_ASSOC);
// Upload directory
$upload_dir = '../../common/author/final_submissions/';
if (!file_exists($upload_dir)) {
    if (!mkdir($upload_dir, 0755, true)) {
        echo json_encode(['success' => false, 'message' => 'Failed to create upload directory']);
        exit();
    }
}
$uploaded_files = [];
$allowed_extensions = ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png'];
$max_file_size = 5 * 1024 * 1024; // 5MB
// Process file uploads
$file_fields = [
    'payment_receipt' => 'Payment Receipt',
    'declaration_form' => 'Declaration Form',
    'final_manuscript' => 'Final Manuscript'
];
foreach ($file_fields as $field => $label) {
    if (isset($_FILES[$field]) && $_FILES[$field]['error'] === UPLOAD_ERR_OK) {
        // FIXED: Skip if already submitted (don't exit, just continue to next field)
        if ($existing_submission && !empty($existing_submission[$field])) {
            // Optionally log: error_log("Skipping already-submitted file: $field");
            continue; // Skip this field, process others
        }
       
        $file = $_FILES[$field];
        $file_extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
       
        // Validate file extension
        if (!in_array($file_extension, $allowed_extensions)) {
            echo json_encode([
                'success' => false,
                'message' => "Invalid file type for $label. Allowed: PDF, DOC, DOCX, JPG, PNG"
            ]);
            exit();
        }
       
        // Validate file size
        if ($file['size'] > $max_file_size) {
            echo json_encode([
                'success' => false,
                'message' => "$label exceeds maximum file size of 5MB"
            ]);
            exit();
        }
       
        // Generate unique filename
        $unique_name = $tracking_code . '_' . $field . '_' . time() . '.' . $file_extension;
        $destination = $upload_dir . $unique_name;
       
        // Move uploaded file
        if (move_uploaded_file($file['tmp_name'], $destination)) {
            $uploaded_files[$field] = 'final_submissions/' . $unique_name;
        } else {
            echo json_encode([
                'success' => false,
                'message' => "Failed to upload $label"
            ]);
            exit();
        }
    }
}
// Check if at least one file was uploaded (new one)
if (empty($uploaded_files)) {
    echo json_encode([
        'success' => false,
        'message' => 'Please upload at least one file'
    ]);
    exit();
}
try {
    if ($existing_submission) {
        // Update existing submission with new files only
        $update_fields = [];
        $update_values = [];
       
        foreach ($uploaded_files as $field => $path) {
            $update_fields[] = "$field = ?";
            $update_values[] = $path;
        }
       
        if (!empty($update_fields)) { // Only update if new files
            $update_values[] = $submission_id;
            $update_values[] = $user_id;
           
            $update_sql = "UPDATE final_submissions SET " . implode(', ', $update_fields) . ", updated_at = NOW() WHERE submission_id = ? AND author_id = ?";
            $update_stmt = $pdo->prepare($update_sql);
            $update_stmt->execute($update_values);
        }
       
        // FIXED: Always re-check completeness after potential update
        $check_complete = $pdo->prepare("SELECT * FROM final_submissions WHERE submission_id = ? AND author_id = ?");
        $check_complete->execute([$submission_id, $user_id]);
        $updated_submission = $check_complete->fetch(PDO::FETCH_ASSOC);
       
        $is_complete = !empty($updated_submission['payment_receipt']) &&
                       !empty($updated_submission['declaration_form']) &&
                       !empty($updated_submission['final_manuscript']);
       
        // Update is_complete if needed
        $complete_stmt = $pdo->prepare("UPDATE final_submissions SET is_complete = ? WHERE submission_id = ? AND author_id = ?");
        $complete_stmt->execute([$is_complete ? 1 : 0, $submission_id, $user_id]);
       
        echo json_encode([
            'success' => true,
            'message' => 'Files updated successfully',
            'is_complete' => $is_complete
        ]);
    } else {
        // Create new final submission record
        $insert_stmt = $pdo->prepare("
            INSERT INTO final_submissions
            (author_id, submission_id, tracking_code, payment_receipt, declaration_form, final_manuscript, is_complete, created_at, updated_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
        ");
       
        // FIXED: Set is_complete based on whether all three were uploaded now
        $is_complete = (count($uploaded_files) === 3) ? 1 : 0;
       
        $insert_stmt->execute([
            $user_id,
            $submission_id,
            $tracking_code,
            $uploaded_files['payment_receipt'] ?? null,
            $uploaded_files['declaration_form'] ?? null,
            $uploaded_files['final_manuscript'] ?? null,
            $is_complete
        ]);
       
        echo json_encode([
            'success' => true,
            'message' => 'Files submitted successfully',
            'is_complete' => $is_complete
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>