<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Database configuration
$db_host = 'localhost';
$db_user = 'rsisinternation1_new_journal_flo';
$db_pass = 'weDCVrG3$%fv78T';
$db_name = 'rsisinternation1_new_journal_flow';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Connection failed: ' . $e->getMessage()]);
    exit();
}

// Check if user is logged in and is an author
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'author') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized access. Please log in.']);
    exit();
}

$user_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit();
}

$submission_id = $_POST['submission_id'] ?? null;
if (!$submission_id || !is_numeric($submission_id)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Missing or invalid submission ID.']);
    exit();
}

// Verify submission ownership and status
try {
    $stmt = $pdo->prepare("SELECT id, tracking_code, status FROM submissions WHERE id = ? AND author_id = ?");
    $stmt->execute([$submission_id, $user_id]);
    $submission = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$submission || $submission['status'] !== 'resubmit') {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Submission not found or not eligible for resubmission.']);
        exit();
    }
} catch (PDOException $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    exit();
}

// Handle file upload
if (!isset($_FILES['resubmission_file']) || $_FILES['resubmission_file']['error'] !== UPLOAD_ERR_OK) {
    header('Content-Type: application/json');
    $error_msg = '';
    switch ($_FILES['resubmission_file']['error']) {
        case UPLOAD_ERR_INI_SIZE:
        case UPLOAD_ERR_FORM_SIZE:
            $error_msg = 'File size exceeds the maximum allowed size.';
            break;
        case UPLOAD_ERR_PARTIAL:
            $error_msg = 'File upload was incomplete.';
            break;
        case UPLOAD_ERR_NO_FILE:
            $error_msg = 'No file was uploaded.';
            break;
        default:
            $error_msg = 'File upload error occurred.';
    }
    echo json_encode(['success' => false, 'message' => $error_msg]);
    exit();
}

$file = $_FILES['resubmission_file'];
$allowed_ext = ['doc', 'docx', 'rtf'];
$file_ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

if (!in_array($file_ext, $allowed_ext)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid file type. Allowed formats: .doc, .docx, .rtf']);
    exit();
}

if ($file['size'] > 5 * 1024 * 1024) { // 5MB limit
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'File size exceeds 5MB limit.']);
    exit();
}

// Generate unique filename
$tracking_code = $submission['tracking_code'];
$filename = $tracking_code . '_resubmission_' . time() . '.' . $file_ext;
$upload_dir = '../../common/author/uploads/resubmission/';
$upload_path = $upload_dir . $filename;

// Ensure upload directory exists
if (!is_dir($upload_dir)) {
    if (!mkdir($upload_dir, 0755, true)) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Failed to create upload directory.']);
        exit();
    }
}

// Move uploaded file
if (!move_uploaded_file($file['tmp_name'], $upload_path)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Failed to save the uploaded file.']);
    exit();
}

// Update submission in database
try {
    $stmt = $pdo->prepare("
        UPDATE submissions 
        SET resubmission_file = ?, status = 'submitted', submitted_at = NOW() 
        WHERE id = ?
    ");
    $stmt->execute([$filename, $submission_id]);
    
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true, 
        'message' => 'Resubmission successful! Your revised manuscript has been submitted for review. Status updated to "Submitted".'
    ]);
} catch (PDOException $e) {
    // Rollback: delete the uploaded file on database error
    if (file_exists($upload_path)) {
        unlink($upload_path);
    }
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Database update failed: ' . $e->getMessage()]);
}
?>